package com.zjty.project.state.server.pojo;


import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.web.multipart.MultipartFile;

import javax.persistence.*;
import java.util.Date;

//文件表
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class File {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Integer id;
    @ApiModelProperty("文件类型")
    private Integer type;
    @ApiModelProperty("文件名称")
    private String name;
    @ApiModelProperty("文件状态是否已上传1：文件已上传；-1：文件未上传")
    private Integer status=-1;
    @ApiModelProperty("文件路径")
    private String path;
    @ApiModelProperty("是否被删除")
    private boolean deleted;
    @Transient
    @ApiModelProperty("软替ID")
    private Integer softId;
    @Transient
    @ApiModelProperty("硬体id")
    private Integer hardId;
    @ApiModelProperty("项目id")
    private Integer projectId;
    @ApiModelProperty("里程碑id")
    private Integer goalId;
    @ApiModelProperty("上传人id")
    private Integer userId;
    @ApiModelProperty("上传人name")
    private String userName;
    @ApiModelProperty("创建时间")
    private Date createTime;
    @ApiModelProperty("上传时间")
    private Date uploadTime;

    @ApiModelProperty("上传的文件")
    @Transient
//    private List<MultipartFile> fileList;
    private MultipartFile multipartFile;
}
