package com.zjty.project.state.server.pojo;


import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.util.Date;

/**
 * 历史表
 */
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class History {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Integer id;

    @ApiModelProperty("操作时间")
    private Date time;

    @ApiModelProperty("操作人id")
    private Integer userId;
    @ApiModelProperty("操作人姓名")
    private String userName;

    /**
     * 操作内容
     */
    @ApiModelProperty("操作内容")
    private String content;

    /**
     * 软替id
     */
//    private Integer softId;

    /**
     * 硬替id
     */
//    private Integer hardId;

    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Integer projectId;
}
