package com.zjty.project.state.server.pojo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

/**
 * 微服务-项目关系表
 */
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MicroserverProject {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private int id;
    /**
     * 项目ID
     */
    private int projectId;
    /**
     * 微服务ID
     */
    private int microServerId;

    public MicroserverProject(int projectId, int microServerId) {
        this.projectId = projectId;
        this.microServerId = microServerId;
    }
}
