package com.zjty.project.state.server.pojo;


import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.List;

//进度计划表
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Plan {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Integer id;

    /**
     * 计划名称
     */
    private String name;

    /**
     * 0:模板，1：普通
     */
    private Integer type;

    /**
     * 状态（0：删除 1：未删除）
     */
    private Integer state = 1;

    /*
    里程碑相关数据
     */
    @Transient
    private List<Goal> goals;
}
