package com.zjty.project.state.server.pojo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

/**
 * 软替计划(里程碑)-角色关系表
 */
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PlanRole {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private int id;
    /**
     *里程碑ID
     */
    private int goalId;
    /**
     * 角色ID
     */
    private int roleId;
    /**
     * 操作类型（提交人、参与人、审核人）
     */
    private int type;
    /**
     * 评论
     */
    private String des;
    /**
     * 状态（完成或未完成）
     */
    private int state;
}
