package com.zjty.project.state.server.pojo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

/**
 * 软替任务-单位表
 */
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SoftUnit {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private int id;
    /**
     * 单位ID
     */
    private int unitId;
    /**
     * 单位名称
     */
    private int unitName;
    /**
     * 软替任务ID
     */
    private int softId;
    /**
     * 软件名称
     */
    private String softName;
    /**
     * 单位在这个软替任务中的角色ID
     */
    private int roleId;
    /**
     * 角色名称
     */
    private String roleName;

    /**
     * 状态(0:删除 1：未删除)
     */
    private Integer state = 1;
}
