package com.zjty.project.state.server.pojo.person;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;


/**
 * @program: bserver
 * @description: 人员类
 * @author: LiuJie
 * @create: 2019-05-15 11:27
 **/

@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("人员类")
//@Entity
public class Personnel {
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
//    @Id
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    @ApiModelProperty("姓名")
    private String name;
    @ApiModelProperty("性别 0:女 1：男")
    private Integer sex;
    @ApiModelProperty("类别 0:本单位 1：其他")
    private Integer type;
    @ApiModelProperty("联系电话")
    private String phone;
    @ApiModelProperty("身份证号")
    private String idCard;
    @ApiModelProperty("权限")
    private Integer author;
    @ApiModelProperty("备注")
    private String description;
    @ApiModelProperty("用户名")
    private String username;
    @ApiModelProperty("密码")
    private String password;
    @ApiModelProperty("人员上一次登录、操作时间")
    private Date loginTime;
    @ApiModelProperty("来源")
    private String source;
    @ApiModelProperty("状态，0：未删除，1已删除，2未推送")
    private Integer status;
    @ApiModelProperty("是否是超级管理员，0：不是，1：是")
    private Integer isAdmin = 0;
    @ApiModelProperty("账户是否被锁定，-1：没有锁定，1：被锁定")
    private Integer locked = -1;
    @ApiModelProperty("sessionId")
    private String sesionId;
    @ApiModelProperty("人员类型，0：普通用户；1：管理员；2：安全员；3：审计员")
    private Integer part;

    @Override
    public String toString() {
        return "{\"id\":\"" + id + "\",\"name\":\""+name+"\"," +
                "\"sex\":\""+ sex + "\",\"type\":\""+type+"\","+
                "\"phone\":\""+ phone + "\",\"idCard\":\""+idCard+"\","+
                "\"author\":\""+ author + "\",\"description\":\""+description+"\","+
                "\"username\":\""+ username + "\",\"password\":\""+password+"\","+
                "\"loginTime\":\""+ loginTime + "\",\"source\":\""+source+"\","+
                "\"status\":\""+ status + "\",\"isAdmin\":\""+isAdmin+"\","+
                "\"locked\":\""+ locked + "\",\"sesionId\":\""+sesionId+"\","+
                "\"part\":\""+ part + "\"}";
    }
}
