package com.zjty.project.state.server.pojo.project;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

/**
* @Description:  项目相关硬件产品
* @Author: LiuJie
* @Date: 2020/3/9
*/
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Hardware {
    @ApiModelProperty("主键")
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    @ApiModelProperty("产品名称")
    private String name;
    @ApiModelProperty("产品类型1:服务器、2CPU、3操作系统、4数据库、5中间件、6其他")
    private Integer form;
    @ApiModelProperty("产品型号")
    private String model;
    @ApiModelProperty("厂商")
    private String producer;
    @ApiModelProperty("预计数量")
    private Integer expect;
    @ApiModelProperty("已到货数量")
    private Integer actual;

    @ApiModelProperty("相关项目id")
    private Integer projectId;
}
