package com.zjty.project.state.server.pojo.project;

import com.zjty.project.state.server.pojo.Goal;
import com.zjty.project.state.server.pojo.MicroServer;
import com.zjty.project.state.server.pojo.SoftWork;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

//项目表
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Project {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Integer id;

    @ApiModelProperty("项目名称")
    private String name;
    @ApiModelProperty("单位名称")
    private String unit;
    @ApiModelProperty("技术路线ID")
    private Integer techId;
    @Transient
    @ApiModelProperty("技术路线名称")
    private String techName;
    @ApiModelProperty("建设方Id")
    private Integer consId;
    @Transient
    @ApiModelProperty("建设方名称")
    private String consName;
    @ApiModelProperty("集成商Id")
    private Integer gratorId;
    @Transient
    @ApiModelProperty("集成商名称")
    private String gratorName;
    @ApiModelProperty("开发商Id")
    private Integer devId;
    @Transient
    @ApiModelProperty("开发商名称")
    private String devName;
    @ApiModelProperty("监理方Id")
    private Integer thirdId;
    @Transient
    @ApiModelProperty("监理方名称")
    private String thirdName;
    @ApiModelProperty("开始时间")
    private Date startTime;
    @ApiModelProperty("结束时间")
    private Date endTime;
    @ApiModelProperty("项目描述")
    private String des;

    /**
     * 软体进度
     */
    private int softProcess;

    /**
     * 硬替进度
     */
    private int hardProcess;

    /**
     * 进度
     */
    private int process;

    @Transient
    private Map<String,Integer> processMap;

    /**
     * 是否被删除 true删除false未删除
     */
    @Transient
    private boolean deleted;

    /**
     * 策略
     * 0:优先 1：普通
     */
    @Transient
    private int strategy;

    /**
     * 计划系数 默认1 延后1.1、1.2
     */
    @Transient
    private int planRate;



    @Transient
    private List<MicroServer> microIdList = new ArrayList<>();

    @ApiModelProperty("硬替产品集合")
    @Transient
    private List<Hardware> hardwares;
    @ApiModelProperty("软替集合")
    @Transient
    private List<SoftWork> softWorks;
    @ApiModelProperty("里程碑集合")
    @Transient
    private List<Goal> goals;
}
