package com.zjty.project.state.server.pojo.properties;

import java.util.HashMap;
import java.util.Map;

/**
 * @program: bserver
 * @description: Properties配置信息类
 * @author: LiuJie
 * @create: 2019-05-15 11:27
 **/
public class Properties {


    public static final  String MAX = "max";
    public static final  String MIN = "min";
    public static final  String AVG = "avg";


    public static final  Integer NUM_f1 = -1;
    public static final  Integer NUM_0 = 0;
    public static final  Integer NUM_1 = 1;
    public static final  Integer NUM_2 = 2;
    public static final  Integer NUM_3 = 3;


    /**
     * 评分
     */
    public static final String HEALTH = "health";
    public static final String SCORE = "score";
    public static final Double TATOL_SCORE = 100.00;
    public static final Double LOWEST = 60.00;
    public static final Double SCORE_10 = 10.00;
    public static final Double SCORE_1 = 1.00;
    public static final Double SCORE_0 = 0.10;
    /**
     * 实时数据
     */
    public static final String REAL_DATA = "realData";
    /**
     * 设备离线统计
     */
    public static final String NET_STATUS = "netStatus";


    /**
     * 报警消息的状态
     *  消息处理结果（0：未查看1：未处理2：已处理3：已结束）
     */
    public static final Integer STATUS_0 = 0;
    public static final Integer STATUS_1 = 1;
    public static final Integer STATUS_2 = 2;
    public static final Integer STATUS_3 = 3;
    /**
     * 消息等级
     */
    public static final  Integer LEVEL1 = 1;
    public static final  Integer LEVEL2 = 2;
    public static final  Integer LEVEL3 = 3;
    public static final  Integer LEVEL4 = 4;
    public static final  Integer LEVEL5 = 5;

    /**
     * 报警信息与报警消除信息集合
     */
    public static final  String LOG = "log";
    public static final  String MESSAGE = "message";
    public static final  String MONTH = "month";
    public static final  String LEVEL = "level";
    public static final  String YEAR = "year";
    public static final  String MESSAGES = "messages";
    public static final  String EQUIPMENTS = "equipments";
    public static final  String CHECKIDS = "checkIds";
    public static final  String ALARM_EQUIPMENT = "alarmEquipment";
    public static final  String ALL_ELEMENT = "allElement";
    public static final  String WRONG = "wrong";
    public static final  String NORMAL = "normal";
    public static final  String CHECK = "check";
    public static final  String TAKE = "take";

    /**
     * 设备类型
     */
    public static final Map<Integer,String> EQUIPMENT_TYPE = new HashMap<>();
    static {

    }
    /**
     * 配电设备
     */
    public static final  String TYPE_1 = "1";
    /**
     * 环境设备
     */
    public static final  String TYPE_2 = "2";
    /**
     * 安防设备
     */
    public static final  String TYPE_3 = "3";
    /**
     * 消防设备
     */
    public static final  String TYPE_4 = "4";
    /**
     * 网络设备
     */
    public static final  String TYPE_5 = "5";
    /**
     * 防雷
     */
    public static final  String TYPE_6 = "6";
    /**
     * 机柜
     */
    public static final  String TYPE_7 = "7";
    /**
     * 配电柜
     */
    public static final  Integer DEVICE_NUM_101 = 101;
    public static final  String PEI_DIAN = "peiDian";
    public static final  String PEI_DIAN_020 = "peidian020";
    public static final  String PEI_DIAN_021 = "peidian021";
    public static final  String PEI_DIAN_022 = "peidian022";
    public static final  String PEI_DIAN_023 = "peidian023";
    public static final  String DIAN_YA = "dianYa";
    public static final  String DIAN_LIU = "dianLiu";
    /**
     * A、B、C相电压
     */
    public static final  String DIAN_YA_A = "aDianYa";
    public static final  String DIAN_YA_B = "bDianYa";
    public static final  String DIAN_YA_C = "cDianYa";


    /**
     * UPS
     */
    public static final  Integer DEVICE_NUM_102 = 102;
    public static final  String UPS = "ups";
    public static final  String DIAN_LIANG = "dianLiang";
    public static final  String UPS_151 = "ups151";
    /**
     * 蓄电池
     */
    public static final  Integer DEVICE_NUM_103 = 103;
    /**
     * 发电机
     */
    public static final  Integer DEVICE_NUM_104 = 104;
    /**
     * UPS主机电池组
     */
    public static final  Integer DEVICE_NUM_105 = 105;
    /**
     * 检测模块
     */
    public static final  Integer DEVICE_NUM_106 = 106;
    /**
     *  精密空调
     */
    public static final  Integer DEVICE_NUM_201 = 201;
    /**
     * 洁净度检测设备
     */
    public static final  Integer DEVICE_NUM_202 = 202;
    /**
     * 新风机
     */
    public static final  Integer DEVICE_NUM_203 = 203;
    public static final  String XIN_FENG = "xinFeng";
    /**
     * 温湿度探测器
     */
    public static final  Integer DEVICE_NUM_204 = 204;
    /**
     * 漏水探测器
     */
    public static final  Integer DEVICE_NUM_205 = 205;
    public static final  String LOU_SHUI = "louShui";
    /**
     * 氢气探测器
     */
    public static final  Integer DEVICE_NUM_206 = 206;
    /**
     * 二氧化碳探测器
     */
    public static final  Integer DEVICE_NUM_207 = 207;
    /**
     *  PM2.5探测器
     */
    public static final  Integer DEVICE_NUM_208 = 208;
    /**
     * 烟传感器
     */
    public static final  Integer DEVICE_NUM_209 = 209;

    /**
     * 小空调
     */
    public static final  Integer DEVICE_NUM_211 = 211;
    /**
     * 通道监控点（虚拟设备）
     */
    public static final  Integer DEVICE_NUM_301 = 301;
    /**
     * 无人监控点
     */
    public static final  Integer DEVICE_NUM_302 = 302;
    /**
     * 门禁系统
     */
    public static final  Integer DEVICE_NUM_303= 303;
    /**
     * 摄像头
     */
    public static final  Integer DEVICE_NUM_304= 304;
    /**
     * 七氟丙烷灭火器
     */
    public static final  Integer DEVICE_NUM_401= 401;
    public static final  String XIAO_FANG= "xiaoFang";
    /**
     * 小灭火器
     */
    public static final  Integer DEVICE_NUM_402= 402;
    /**
     * 消防模块
     */
    public static final  Integer DEVICE_NUM_403= 403;
    /**
     * 机柜
     */
    public static final  Integer DEVICE_NUM_501= 501;
    /**
     * 防雷器
     */
    public static final  Integer DEVICE_NUM_601= 601;
    public static final  String FANG_LEI= "fangLei";
    static {
        EQUIPMENT_TYPE.put(DEVICE_NUM_101,"配电柜");
        EQUIPMENT_TYPE.put(DEVICE_NUM_102,"UPS");
        EQUIPMENT_TYPE.put(DEVICE_NUM_103,"蓄电池");
        EQUIPMENT_TYPE.put(DEVICE_NUM_104,"发电机");
        EQUIPMENT_TYPE.put(DEVICE_NUM_105,"UPS主机电池组");
        EQUIPMENT_TYPE.put(DEVICE_NUM_106,"监测模块");
        EQUIPMENT_TYPE.put(DEVICE_NUM_201,"精密空调");
        EQUIPMENT_TYPE.put(DEVICE_NUM_202,"洁净度探测器");
        EQUIPMENT_TYPE.put(DEVICE_NUM_203,"新风机");
        EQUIPMENT_TYPE.put(DEVICE_NUM_204,"温湿度探测器");
        EQUIPMENT_TYPE.put(DEVICE_NUM_205,"漏水探测器");
        EQUIPMENT_TYPE.put(DEVICE_NUM_206,"氢气浓度探测器");
        EQUIPMENT_TYPE.put(DEVICE_NUM_207,"二氧化碳探测器");
        EQUIPMENT_TYPE.put(DEVICE_NUM_208,"PM2.5探测器");
        EQUIPMENT_TYPE.put(DEVICE_NUM_209,"烟传感器");
        EQUIPMENT_TYPE.put(DEVICE_NUM_211,"小空调");
        EQUIPMENT_TYPE.put(DEVICE_NUM_303,"门禁系统");
        EQUIPMENT_TYPE.put(DEVICE_NUM_304,"摄像头");
        EQUIPMENT_TYPE.put(DEVICE_NUM_304,"摄像头");
        EQUIPMENT_TYPE.put(DEVICE_NUM_401,"七氟丙烷灭火器");
        EQUIPMENT_TYPE.put(DEVICE_NUM_402,"小灭火器");
        EQUIPMENT_TYPE.put(DEVICE_NUM_403,"消防模块");
        EQUIPMENT_TYPE.put(DEVICE_NUM_501,"机柜");
        EQUIPMENT_TYPE.put(DEVICE_NUM_601,"防雷器");
    }

    /*
     *  设备所属编号与消息等级
     */
    //配电柜
    public static final  String STATUS_101 = "boxStatus";
    public static final  String NETWORK_STATUS_101 = "boxNetworkStatus";
    //UPS
    public static final  String STATUS_102 = "upsStatus";
    public static final  String NETWORK_STATUS_102 = "upsNetworkStatus";
    //蓄电池
    public static final  String STATUS_103 = "cellStatus";
    public static final  String NETWORK_STATUS_103 = "cellNetworkStatus";
    //发电机
    public static final  String STATUS_104 = "dynamoStatus";
    public static final  String NETWORK_STATUS_104 = "dynamoNetworkStatus";
    //精密空调
    public static final  String STATUS_201 = "airStatus";
    public static final  String NETWORK_STATUS_201 = "airNetworkStatus";
    //洁净度监测设备
    public static final  String STATUS_202 = "cleanStatus";
    public static final  String NETWORK_STATUS_202 = "cleanNetworkStatus";
    //新风机
    public static final  String STATUS_203 = "cleanStatus";
    public static final  String NETWORK_STATUS_203 = "cleanNetworkStatus";
    //温湿度探测器
    public static final  String STATUS_204 = "humitureStatus";
    public static final  String NETWORK_STATUS_204 = "humitureNetworkStatus";
    public static final  String WEN_DU = "wenDu";
    public static final  String SHI_DU = "shiDu";
    public static final  String WEN_DU_001 = "wenshi001";
    public static final  String WEN_DU_002 = "wenshi002";
    //漏水监测设备
    public static final  String STATUS_205 = "leakStatus";
    public static final  String NETWORK_STATUS_205 = "leakNetworkStatus";
    //氢气探测器
    public static final  String STATUS_206 = "hStatus";
    public static final  String NETWORK_STATUS_206 = "hNetworkStatus";
    //二氧化碳浓度监测设备
    public static final  String STATUS_207 = "coStatus";
    public static final  String NETWORK_STATUS_207 = "coNetworkStatus";
    public static final  String ER_YANG = "erYang";
    public static final  String ER_YANG_001 = "eryang001";

    //PM2.5监测设备
    public static final  String STATUS_208 = "pmStatus";
    public static final  String NETWORK_STATUS_208 = "pmNetworkStatus";
    public static final  String PM = "pm";
    public static final  String PM_001 = "pm001";
    //烟传感器
    public static final  String STATUS_209 = "cigaretteStatus";
    public static final  String NETWORK_STATUS_209 = "cigaretteNetworkStatus";
    //防雷器
    public static final  String STATUS_210 = "cigaretteStatus";
    public static final  String NETWORK_STATUS_210 = "aisleNetworkStatus";
    //小空调
    public static final  String STATUS_211 = "minAirStatus";
    public static final  String NETWORK_STATUS_211 = "minAirNetworkStatus";
    //通道监控点
    public static final  String STATUS_301 = "cigaretteStatus";
    //内容设备（该监控点下所属任意摄像头或门禁发生故障）
    public static final  String NETWORK_STATUS_301 = "aisleNetworkStatus";
    //无人监控点
    //无人报警
    public static final  String STATUS_302 = "unmannedAlarm";
    public static final  String NETWORK_STATUS_302 = "unmannedNetworkStatus";
    //门禁系统
    public static final  String STATUS_303 = "aisleOpenAlarm";
    //门禁设备故障
    public static final  String NETWORK_STATUS_303 = "entranceNetworkStatus";
    //摄像头设备故障
    public static final  String STATUS_304 = "cameraStatus";
    public static final  String NETWORK_STATUS_304 = "cameraNetworkStatus";
    //七氟丙烷灭火器
    public static final  String STATUS_401 = "fireStatus";
    public static final  String NETWORK_STATUS_401 = "fireNetworkStatus";
    //机柜
    public static final  String STATUS_501 = "cabinetStatus";
    public static final  String NETWORK_STATUS_501 = "cabinetNetworkStatus";
    //防雷
    public static final  String STATUS_601 = "fireStatus";
    public static final  String NETWORK_STATUS_601 = "fireNetworkStatus";


    //设备接入状态（0：正常接入1：无效接入）
    public static final  String NETWORK_STATUS = "networkStatus";
    public static final  String NETWORK_STATUS_NORMAL = "0";

    /**
     * 设备运行状态
     */
    public static final  String STATUS = "status";
    /**
     * 设备运行状态正常
     */
    public static final  Integer STATUS_NORMAL = 0;
    /**
     * 设备运行状态异常
     */
    public static final  Integer STATUS_INVALID = 1;
    /**
     * 设备连接失败
     */
    public static final  Integer STATUS_DOWN = -1;

    public static final  String CAPTURE = "capture";//人员抓拍信息



}
