package com.zjty.project.state.server.pojo.user;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;

//用户表
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class User {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Integer id;
    @ApiModelProperty("姓名")
    private String name;
    @ApiModelProperty("性别")
    private Integer sex;
    @ApiModelProperty("用户名")
    private String userName;
    @ApiModelProperty("密码")
    private String password;
    @ApiModelProperty("角色id")
    private Integer roleId;
    @Transient
    @ApiModelProperty("角色名称")
    private String roleName;
    @ApiModelProperty("单位id")
    private Integer unitId;
    @Transient
    @ApiModelProperty("单位名称")
    private String unitName;
    @ApiModelProperty("是否被删除1：已删除，-1：未删除")
    private Integer deleted;
    @ApiModelProperty("联系方式")
    private String number;
    @ApiModelProperty("照片路径")
    private String path;

    @ApiModelProperty("用户类型 1：后台，2：前台")
    @Transient
    private Integer type;
    @ApiModelProperty("本次登录的sessionId")
    @Transient
    private String sessionId;
}
