package com.zjty.project.state.server.service;

import com.github.wenhao.jpa.Specifications;
import com.zjty.project.state.server.dao.HardwareDao;
import com.zjty.project.state.server.pojo.project.Hardware;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.PageResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Optional;

/**
 * @program: state
 * @description:
 * @author: LiuJie
 * @create: 2020-02-26 13:45
 **/
@Service
public class HardwareService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private HardwareDao hardwareDao;

    public List<Hardware> findAll() {
        return hardwareDao.findAll();
    }

    @Transactional(rollbackFor = Exception.class)
    public void add(Hardware hardware) {
        hardwareDao.save(hardware);
    }

    public Hardware findById(Integer hardwareId) {
        if (hardwareId==null){
            return null;
        }
        Optional<Hardware> optional = hardwareDao.findById(hardwareId);
        return optional.isPresent()?optional.get():null;
    }

    @Transactional(rollbackFor = Exception.class)
    public void update(Hardware hardware) {
        Integer hardwareId = hardware.getId();
        if (hardwareId!=null){
            hardwareDao.saveAndFlush(hardware);
        }
    }

    @Transactional(rollbackFor = Exception.class)
    public void saveAll(List<Hardware> hardwares, Integer projectId) {
        if (hardwares!=null&&hardwares.size()>0&&projectId!=null){
            for (Hardware hardware:hardwares){
                hardware.setProjectId(projectId);
                save(hardware);
            }

        }
    }
    @Transactional(rollbackFor = Exception.class)
    public void save(Hardware hardwares) {
        hardwareDao.save(hardwares);
    }

    public PageResult<Hardware> search(BaseRequest<Hardware> baseRequest) {
        Hardware hardware = baseRequest.getT();
        Integer projectId = hardware.getProjectId();

        Specification<Hardware> specifications = Specifications.<Hardware>and()
                .eq( "projectId",projectId)
                .like(!StringUtils.isEmpty(hardware.getName()),"name","%"+hardware.getName()+"%")
                .build();
        Integer page = baseRequest.getPage();
        Integer pageSize = baseRequest.getPageSize();
        if (page==null || page<=0){
            page = 1;
        }
        if (pageSize==null || pageSize<=0){
            pageSize = 10;
        }
        Pageable pageable = PageRequest.of(page-1, pageSize, Sort.Direction.DESC, "id");
        Long count = hardwareDao.count(specifications);
        List<Hardware> hardwareList = hardwareDao.findAll(specifications,pageable).getContent();
        return new PageResult<>(page,pageSize,count,hardwareList);
    }
}
