package com.zjty.project.state.server.service;

import com.github.wenhao.jpa.Specifications;
import com.zjty.project.state.base.response.ServerResponse;
import com.zjty.project.state.server.dao.HistoryDao;
import com.zjty.project.state.server.pojo.History;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.PageResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * <h4>Description : 操作历史管理</h4>
 *
 * @author : czq
 * @Date : 2020-02-27 11:10
 */
@Service
public class HistoryService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private final HistoryDao historyDao;

    public HistoryService(HistoryDao historyDao) {
        this.historyDao = historyDao;
    }

    public ServerResponse findHistory(BaseRequest<History> baseRequest) {
        History history = baseRequest.getT();
        Specification<History> spec = Specifications.<History>and()
                .eq(history.getProjectId()!=null,"projectId",history.getProjectId())
                .eq(history.getUserId()!=null,"userId",history.getUserId())
//                .eq(history.getSoftId()!=null,"softId",history.getSoftId())
//                .eq(history.getHardId()!=null,"hardId",history.getHardId())
                .build();
        Integer page = baseRequest.getPage();
        Integer pageSize = baseRequest.getPageSize();
        if (page==null || page<=0){
            page = 1;
        }
        if (pageSize==null || pageSize<=0){
            pageSize = 10;
        }
        Pageable pageable = PageRequest.of(page-1, pageSize, Sort.Direction.DESC, "id");
        long count = historyDao.count(spec);
        List<History> historyList = historyDao.findAll(spec,pageable).getContent();
        return ServerResponse.success(new PageResult<>(page,pageSize,count,historyList));
    }

    public PageResult<History> search(BaseRequest<History> baseRequest) {
        History history = baseRequest.getT();
        Integer projectId = history.getProjectId();
        Specification<History> specifications = null;
        specifications = Specifications.<History>and()
                .eq( "projectId",projectId)
                .like(!StringUtils.isEmpty(history.getContent()),"content","%"+history.getContent()+"%")
//                    .eq(history.getName()!=null && !Objects.equals(history.getName(), ""),"name","%"+project.getName()+"%")
                .build();
        Integer page = baseRequest.getPage();
        Integer pageSize = baseRequest.getPageSize();
        if (page==null || page<=0){
            page = 1;
        }
        if (pageSize==null || pageSize<=0){
            pageSize = 10;
        }
        Pageable pageable = PageRequest.of(page-1, pageSize, Sort.Direction.DESC, "id");
        Long count = historyDao.count(specifications);
        List<History> historyList = historyDao.findAll(specifications,pageable).getContent();
        return new PageResult<>(page,pageSize,count,historyList);
    }

    public void addHistory(History history) {
        historyDao.save(history);
    }



}
