package com.zjty.project.state.server.service;

import com.alibaba.fastjson.JSON;
import com.github.wenhao.jpa.Specifications;
import com.zjty.project.state.server.dao.ProduceDao;
import com.zjty.project.state.server.pojo.Produce;
import com.zjty.project.state.server.pojo.Tech;
import com.zjty.project.state.server.pojo.properties.Properties;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.ExceptionMessage;
import com.zjty.project.state.utils.GetCellValueUtils;
import com.zjty.project.state.utils.PageResult;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.util.*;


/**
 * @program: state
 * @description:
 * @author: LiuJie
 * @create: 2020-02-26 13:45
 **/
@Service
public class ProduceService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ProduceDao produceDao;
    @Autowired
    private TechProduceService techProduceService;
    @Autowired
    private TechService techService;

    /**
     * 批量导入（批量添加）
     */
    private static final String XLS = "xls";
    private static final String XLSK = "xlsx";//定义全局的常量值

    @Transactional(rollbackFor = Exception.class)
    public Map<String, Object> importExcel(MultipartFile file) throws Exception {
        List<Produce> list = new ArrayList<>();
        Map<String, Object> rsultMap = new HashMap<>();
        try {
            Workbook workbook = null;
            String fileName = file.getOriginalFilename();
            if(fileName.endsWith(XLS)) {
                //2003
                try {
                    workbook = new HSSFWorkbook(file.getInputStream());
                } catch (Exception e) {
                    e.printStackTrace( );
                }

            }else if(fileName.endsWith(XLSK)) {
                try {
                    //2007
                    workbook = new XSSFWorkbook(file.getInputStream());
                } catch (Exception e) {
                    e.printStackTrace( );
                }
            }else {
                throw new Exception("文件不是Excel文件");
            }
            Sheet sheet = workbook.getSheet("Sheet1");
            logger.info("sheet：{}",sheet==null);
            int rows = sheet.getLastRowNum();//指定行数。一共多少+
            System.out.println("rows:"+rows);
            if(rows==0) {
                throw new Exception("请填写行数");
            }

            for (int i = 1; i < rows+1; i++) {
                //读取左上端单元格
                Row row = sheet.getRow(i);
                //行不为空
                if(row != null) {
                    //读取cell
                    Produce product = new Produce();
                    //产品名称
                    String name = GetCellValueUtils.getCellValue(row.getCell(0));
                    product.setName(name);
                    //产品分类
                    String type = GetCellValueUtils.getCellValue(row.getCell(1));
                    product.setType(Integer.parseInt(type));
                    //产品类型
                    String form = GetCellValueUtils.getCellValue(row.getCell(2));
                    product.setForm(Integer.parseInt(form));
                    //产品型号
                    String model = GetCellValueUtils.getCellValue(row.getCell(3));
                    product.setModel(model);
                    //产品厂商
                    String producer = GetCellValueUtils.getCellValue(row.getCell(4));
                    product.setProducer(producer);
//               SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//				String time = sdf.format(new Date());
//                String createTime = GetCellValueUtils.getCellValue(row.getCell(3));
//                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
//                Date time = sdf.parse(createTime);
//                product.setCreateTime(time);
//                product.setModifyTime(time);
                    list.add(product);//把实数据放入集合里
                }
            }
            try {
//            groupConfigDao.addBatchMembers(list);//批量添加 (执行sql语句批量增加)
                produceDao.saveAll(list);
                rsultMap.put("status", 1);
                rsultMap.put("data", "导入数据成功");
            } catch (Exception e) {
                rsultMap.put("status", -1);
                rsultMap.put("data", "导入数据异常");
            }
            return rsultMap;
        }catch (Exception e){
            String error = ExceptionMessage.getStackTraceInfo(e);
            logger.error("error:{}",error);
        }
        return rsultMap;
    }




    public List<Produce> findAll() {
        return produceDao.findAll();
    }

    public List<Produce> findAccess() {
        return produceDao.findAllByStatus(Properties.NUM_1);
    }

    @Transactional(rollbackFor = Exception.class)
    public void add(Produce product) {
        produceDao.save(product);
    }

    public PageResult<Produce> search(BaseRequest<Produce> baseRequest) {
        Integer page = baseRequest.getPage();
        Integer pageSize = baseRequest.getPageSize();
        if (page==null || page<=0){
            page = 1;
        }
        if (pageSize==null || pageSize<=0){
            pageSize = 10;
        }


        Produce produce = baseRequest.getT();
//        Produce product = baseRequest.getT();
        Integer techId = null;
        Tech tech = null;
        List<Integer> produceIds = new ArrayList<>();
        Object[] array = produceIds.toArray();
        if (produce!=null){
            techId = produce.getTechId();
            if (techId!=null){
                tech = techService.findById(techId);
                produceIds = techProduceService.findProduceByTech(techId);
                array = produceIds.toArray();
            }
        }
        logger.info("array:{}", JSON.toJSONString(array));
        Specification<Produce> specifications = null;
        if (produce==null){
            specifications = Specifications.<Produce>and()
                    .in(array!=null && array.length>0,"id",array)
                    .build();
        }else {
            if (techId!=null){
                if (array!=null&&array.length>0){
                    specifications = Specifications.<Produce>and()
                            .like(produce.getName()!=null && !Objects.equals(produce.getName(), ""),"name","%"+produce.getName()+"%")
                            .eq(produce.getForm()!=null && !Objects.equals(produce.getForm(), ""),"form",produce.getForm())
                            .eq(produce.getStatus()!=null && !Objects.equals(produce.getStatus(), ""),"status",produce.getStatus())
                            .in("id",array)
                            .build();
                }else {
                    return new PageResult<>(page,pageSize,0L,null);
                }
            }else {
                specifications = Specifications.<Produce>and()
                        .like(produce.getName()!=null && !Objects.equals(produce.getName(), ""),"name","%"+produce.getName()+"%")
                        .eq(produce.getForm()!=null && !Objects.equals(produce.getForm(), ""),"form",produce.getForm())
                        .eq(produce.getStatus()!=null && !Objects.equals(produce.getStatus(), ""),"status",produce.getStatus())
                        .build();
            }
        }

        Pageable pageable = PageRequest.of(page-1, pageSize, Sort.Direction.DESC, "id");
        Long count = produceDao.count(specifications);
        List<Produce> produceList = produceDao.findAll(specifications,pageable).getContent();
        for (Produce p:produceList){
            if(tech!=null){
                p.setTech(tech);
            }else {
                Integer id = p.getId();
                List<Integer> techIds = techProduceService.findTechByProduce(id);
                if (techIds!=null&&techIds.size()>0){
                    tech = techService.findById(techIds.get(0));
                }
                p.setTech(tech);
            }
        }
        return new PageResult<>(page,pageSize,count,produceList);
    }

    public List<Produce> findByTech(Integer techId) {
        List<Produce> produceList = new ArrayList<>();
        if (techId!=null) {
            List<Integer> list = techProduceService.findProduceByTech(techId);
            if (list != null && list.size() > 0) {
                produceList = produceDao.findProduct(list);
            }
        }
        return produceList;
    }

    public Produce findById(Integer produceId) {
        if (produceId==null){
            return null;
        }
        Optional<Produce> optional = produceDao.findById(produceId);
        return optional.isPresent()?optional.get():null;
    }




    public List<Produce> findByForm(Integer form) {
        List<Produce> produceList = new ArrayList<>();
        if (form==null){
            return produceList;
        }
        produceList = produceDao.findAllByFormAndStatus(form,1);
        return produceList;
    }


    public List<Produce> findByType(Integer type) {
        List<Produce> produceList = new ArrayList<>();
        if (type==null){
            return produceList;
        }
        produceList = produceDao.findAllByTypeAndStatus(type,1);
        return produceList;
    }

    @Transactional(rollbackFor = Exception.class)
    public void update(Produce produce) {
        Integer produceId = produce.getId();
        if (produceId!=null){
            produceDao.saveAndFlush(produce);
        }
    }
}
