package com.zjty.project.state.server.service;

import com.alibaba.fastjson.JSON;
import com.github.wenhao.jpa.Specifications;
import com.zjty.project.state.base.exception.MyException;
import com.zjty.project.state.base.response.ResponseCode;
import com.zjty.project.state.server.dao.MicroServerDao;
import com.zjty.project.state.server.dao.MicroServerProjectDao;
import com.zjty.project.state.server.dao.ProjectDao;
import com.zjty.project.state.server.pojo.*;
import com.zjty.project.state.server.pojo.project.Hardware;
import com.zjty.project.state.server.pojo.project.Project;
import com.zjty.project.state.server.pojo.user.User;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.PageResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class ProjectService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ProjectDao projectDao;
    @Autowired
    private MicroServerProjectDao microserverProjectDao;
    @Autowired
    private MicroServerDao microServerDao;

    @Autowired
    private HardwareService hardwareService;
    @Autowired
    private SoftWorkService softWorkService;
    @Autowired
    private GoalService goalService;
    @Autowired
    private TechService techService;
    @Autowired
    private UnitService unitService;
    @Autowired
    private HistoryService historyService;


    public void addProject(Project project, User user) {
        project.setHardProcess(-1);
        project.setSoftProcess(-1);
        project.setProcess(-1);
        project.setPlanRate(1);
        project.setStrategy(1);
        project.setPlanRate(1);
        List<SoftWork> softWorks = project.getSoftWorks();
        List<Hardware> hardwares = project.getHardwares();
        List<Goal> goals = project.getGoals();
        project = projectDao.save(project);
        Integer projectId = project.getId();
        softWorkService.saveAll(softWorks,projectId);
        hardwareService.saveAll(hardwares,projectId);
        goalService.saveAll(goals,project);
        History history = new History(null,new Date(),user.getId(),user.getName(),"新建项目，指定软提计划、硬替计划以及里程碑。",projectId);
        historyService.addHistory(history);
    }

//    public ServerResponse addMicroServer(int id, List<Integer> serverIdList) {
//        Project project = projectDao.getOne(id);
//        for(Integer serverId:serverIdList){
//            microserverProjectDao.save(new MicroserverProject(id,serverId));
//            MicroServer one = microServerDao.getOne(serverId);
//            project.getMicroIdList().add(one);
//        }
//        return ServerResponse.success(project);
//    }

//    public ServerResponse modify(Project project) {
//        return ServerResponse.success(projectDao.save(project));
//    }

//    @Transactional
//    public ServerResponse delete(Project project) {
//        projectDao.getOne(project.getId()).setDeleted(true);
//        return ServerResponse.success();
//    }

    /**
     * 分页查询
     * （项目未开始时进度为-1）
     * @return
     */
//    public ServerResponse page(Project project, Integer page, Integer size) {
//        System.out.println(project.getProcess());
//        Specification<History> spec = Specifications.<History>and()
//                .like(project.getName()!=null,"name","%"+project.getName()+"%")
//                .eq(project.getProcess()!=-1,"process",project.getProcess())
//                .build();
//        Pageable pageable = PageRequest.of(page, size, Sort.Direction.DESC, "id");
//        List<Project> content = projectDao.findAll(spec, pageable).getContent();
//        return ServerResponse.success(new PageResult<Project>(page,size,Long.valueOf(content.size()),content));
//    }

    public Project findById(Integer projectId) {
        if (projectId==null){
            return null;
        }
        Optional<Project> optional = projectDao.findById(projectId);
        return optional.isPresent()?optional.get():null;
    }

    public List<Project> findAll() {
        List<Project> projectList = projectDao.findAll();
        for (Project p:projectList){
            supProject(p);
//            Integer techId = p.getTechId();
//            if (techId!=null){
//                Tech tech = techService.findTech(techId);
//                p.setTechName(tech.getName());
//            }
//            Integer consId = p.getConsId();
//            if (consId!=null){
//                Unit unit = unitService.findById(consId);
//                p.setConsName(unit.getName());
//            }
//            Integer devId = p.getDevId();
//            if (devId!=null){
//                Unit unit = unitService.findById(devId);
//                p.setDevName(unit.getName());
//            }
//            Integer gratorId = p.getGratorId();
//            if (gratorId!=null){
//                Unit unit = unitService.findById(gratorId);
//                p.setGratorName(unit.getName());
//            }
//
//            Integer id = p.getId();
//            Map<String, Integer> process = goalService.getProcess(id);
//            p.setProcessMap(process);

            logger.info("JSON.toJSONString(p):{}",JSON.toJSONString(p));
        }
        return projectList;
    }


    public Tech getTech(Integer id) {
        Project project = findById(id);
        if (project!=null){
            return techService.findTech(project.getTechId());
        }else {
            throw new MyException(ResponseCode.PROJECT_IS_NULL);
        }
    }

    public Project get(Integer id) {
        Project p = findById(id);
        if (p!=null){
            supProject(p);
//            Integer techId = p.getTechId();
//            if (techId!=null){
//                Tech tech = techService.findTech(techId);
//                p.setTechName(tech.getName());
//            }
//            Integer consId = p.getConsId();
//            if (consId!=null){
//                Unit unit = unitService.findById(consId);
//                p.setConsName(unit.getName());
//            }
//            Integer devId = p.getDevId();
//            if (devId!=null){
//                Unit unit = unitService.findById(devId);
//                p.setDevName(unit.getName());
//            }
//            Integer gratorId = p.getGratorId();
//            if (gratorId!=null){
//                Unit unit = unitService.findById(gratorId);
//                p.setGratorName(unit.getName());
//            }
//            Map<String, Integer> process = goalService.getProcess(id);
//            p.setProcessMap(process);
        }

        logger.info("JSON.toJSONString(p):{}",JSON.toJSONString(p));
        return p;
    }

    public PageResult<Project> search(BaseRequest<Project> baseRequest) {
        Integer page = baseRequest.getPage();
        Integer pageSize = baseRequest.getPageSize();
        if (page==null || page<=0){
            page = 1;
        }
        if (pageSize==null || pageSize<=0){
            pageSize = 10;
        }


        Project project = baseRequest.getT();
        Specification<Produce> specifications = null;
        if (project==null){
            specifications = Specifications.<Produce>and()
                    .build();
        }else {
            specifications = Specifications.<Produce>and()
                    .like(project.getName()!=null && !Objects.equals(project.getName(), ""),"name","%"+project.getName()+"%")
                    .eq(project.getConsId()!=null && !Objects.equals(project.getConsId(), ""),"getConsId",project.getConsId())
//                    .eq(produce.getStatus()!=null && !Objects.equals(produce.getStatus(), ""),"status",produce.getStatus())
//                    .in("id",array)
                    .build();

        }
        Pageable pageable = PageRequest.of(page-1, pageSize, Sort.Direction.DESC, "id");
        Long count = projectDao.count(specifications);
        List<Project> projectList = projectDao.findAll(specifications,pageable).getContent();
        for (Project p:projectList){
            supProject(p);
//            Integer techId = p.getTechId();
//            if (techId!=null){
//                Tech tech = techService.findTech(techId);
//                p.setTechName(tech.getName());
//            }
//            Integer consId = p.getConsId();
//            if (consId!=null){
//                Unit unit = unitService.findById(consId);
//                p.setConsName(unit.getName());
//            }
//            Integer devId = p.getDevId();
//            if (devId!=null){
//                Unit unit = unitService.findById(devId);
//                p.setDevName(unit.getName());
//            }
//            Integer gratorId = p.getGratorId();
//            if (gratorId!=null){
//                Unit unit = unitService.findById(gratorId);
//                p.setGratorName(unit.getName());
//            }
//            Integer thirdId = p.getThirdId();
//            if (thirdId!=null){
//                Unit unit = unitService.findById(thirdId);
//                p.setThirdName(unit.getName());
//            }
//
//            Integer id = p.getId();
//            Map<String, Integer> process = goalService.getProcess(id);
//            p.setProcessMap(process);
        }
        return new PageResult<>(page,pageSize,count,projectList);
    }

    public void supProject(Project project) {

        Integer techId = project.getTechId();
        if (techId!=null){
            Tech tech = techService.findTech(techId);
            project.setTechName(tech.getName());
        }
        Integer consId = project.getConsId();
        if (consId!=null){
            Unit unit = unitService.findById(consId);
            project.setConsName(unit.getName());
        }
        Integer devId = project.getDevId();
        if (devId!=null){
            Unit unit = unitService.findById(devId);
            project.setDevName(unit.getName());
        }
        Integer gratorId = project.getGratorId();
        if (gratorId!=null){
            Unit unit = unitService.findById(gratorId);
            project.setGratorName(unit.getName());
        }
        Integer thirdId = project.getThirdId();
        if (thirdId!=null){
            Unit unit = unitService.findById(thirdId);
            project.setThirdName(unit.getName());
        }

        Integer id = project.getId();
        Map<String, Integer> process = goalService.getProcess(id);
        project.setProcessMap(process);

        List<Goal> goalList = goalService.findByProjectId(id);
        project.setGoals(goalList);
    }


}
