package com.zjty.project.state.server.service;

import com.github.wenhao.jpa.Specifications;
import com.zjty.project.state.server.dao.RoleDao;
import com.zjty.project.state.server.pojo.user.Authority;
import com.zjty.project.state.server.pojo.user.Role;
import com.zjty.project.state.server.pojo.user.RoleAuthority;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.PageResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @program: state
 * @description:
 * @author: LiuJie
 * @create: 2020-02-26 10:18
 **/
@Service
public class RoleService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RoleDao roleDao;
    @Autowired
    private RoleAuthorityService roleAuthorityService;
    @Autowired
    private AuthorityService authorityService;


    @Transactional(rollbackFor = Exception.class)
    public void add(Role role) {
        role = roleDao.save(role);
        List<Integer> authorityList = role.getAuthorityList();
        ArrayList<RoleAuthority> list = new ArrayList<>();
        for (Integer a:authorityList){
            list.add(new RoleAuthority(null,role.getId(),a));
        }
        roleAuthorityService.add(list);
    }

    public PageResult<Role> search(BaseRequest<Role> baseRequest) {
        Specification<Role> specifications = null;
        Role role = baseRequest.getT();
        if (role==null){
            specifications = Specifications.<Role>and()
                    .build();
        }else {
            specifications = Specifications.<Role>and()
                    .like(role.getName()!=null && !Objects.equals(role.getName(), ""),"name","%"+role.getName()+"%")
                    .build();
        }

        Integer page = baseRequest.getPage();
        Integer pageSize = baseRequest.getPageSize();
        if (page==null || page<=0){
            page = 1;
        }
        if (pageSize==null || pageSize<=0){
            pageSize = 10;
        }
        Pageable pageable = PageRequest.of(page-1, pageSize, Sort.Direction.DESC, "id");
        Long count = roleDao.count(specifications);
        List<Role> roleList = roleDao.findAll(specifications,pageable).getContent();
        for (Role r:roleList){
            List<Integer> authorityList = roleAuthorityService.findAuthorityByRole(r.getId());
            List<Authority> authorities = authorityService.findAllById(authorityList);
            r.setAuthorities(authorities);
        }
        return new PageResult<Role>(page,pageSize,count,roleList);
    }

    public List<Role> findAll() {
        return roleDao.findAll();
    }

    @Transactional(rollbackFor = Exception.class)
    public void update(Role role) {
        roleAuthorityService.update(role);
    }

    public String getName(Integer unitId) {
        Role role = findById(unitId);
        if (role==null){
            return null;
        }
        return role.getName();
    }

    public Role findById(Integer id) {
        if (id==null){
            return null;
        }
        Optional<Role> optional = roleDao.findById(id);
        Role role = optional.isPresent() ? optional.get() : null;
        return role;
    }
}
