package com.zjty.project.state.server.service;

import com.github.wenhao.jpa.Specifications;
import com.zjty.project.state.server.dao.*;
import com.zjty.project.state.server.pojo.SoftWork;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.PageResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * <h4>Description : 软件管理</h4>
 *
 * @author : czq
 * @Date : 2020-02-26 13:42
 */
@Service
public class SoftWorkService {

    private final SofeWorkDao sofeWorkDao;

    private final SoftUnitDao softUnitDao;

    private final TechProduceDao techProduceDao;

    private final PlanDao planDao;

    private final TechDao techDao;

    @Autowired
    public SoftWorkService(SofeWorkDao sofeWorkDao, SoftUnitDao softUnitDao, TechProduceDao techProduceDao, PlanDao planDao, TechDao techDao) {
        this.sofeWorkDao = sofeWorkDao;
        this.softUnitDao = softUnitDao;
        this.techProduceDao = techProduceDao;
        this.planDao = planDao;
        this.techDao = techDao;
    }

    /**
     * 保存软件的相关信息、与单位的绑定关系、新增一个计划
     * @param softWork 软件相关内容和所绑定的单位
     * @return 返回成功
     */
//    public ServerResponse addSoftWork(SoftWork softWork) {
//         /*
//         *新增计划，绑定计划
//         */
//        Plan plan = planDao.save(new Plan(null, softWork.getName(), 1, 1,null));
//        softWork.setPlanId(plan.getId());
//        /*
//         * 保存软件基本信息,其中包括项目id、技术路线id
//         */
//        SoftWork newSoftWork = sofeWorkDao.save(softWork);
//        /*
//         * 保存单位和软件的绑定关系
//         */
//        List<SoftUnit> softUnits = softWork.getUnits();
//        for (SoftUnit softUnit:softUnits) {
//            softUnit.setSoftId(newSoftWork.getId());
//            softUnit.setSoftName(newSoftWork.getName());
//        }
//        List<SoftUnit> newSoftUnits = softUnitDao.saveAll(softUnits);
//        return ServerResponse.success("新增软件成功");
//    }

    /**
     * 软件列表查询，给出详情右侧是数据
     *  1、分页查询列表
     *  2、遍历列表，查询绑定关系，包括技术路线、单位和角色
     * @param baseRequest，unitId 查询条件、用户的所属机构
     * @return 软替列表
     */
//    public ServerResponse findSoftWork(BaseRequest<SoftWork> baseRequest, Integer unitId) {
//        SoftWork softWork = baseRequest.getT();
//        /*
//        项目id和单位id不能为null
//         */
//        Specification<SoftWork> spec = Specifications.<SoftWork>and()
//                .eq(softWork.getProjectId()!=null,"projectId",softWork.getProjectId())
//                .eq("state",1)
//                .like(softWork.getName()!=null,"name","%"+softWork.getName()+"%")
//                .build();
//        /*
//         * 条件查询软件，获取软件列表
//         */
//        List<SoftWork> softList = sofeWorkDao.findAll(spec);
//        /*
//         * 遍历列表，查询绑定的关系，包括技术路线和单位信息,同时排除不属于自己的软件
//         */
//        List<SoftWork> softs = new ArrayList<>();
//        for (SoftWork softwork:softList) {
//             /*
//            根据产品id查询单位和角色，如开发商--单位
//             */
//            List<SoftUnit> units = softUnitDao.findSoftUnitsBySoftIdAndState(softwork.getId(),1);
//            /*
//            根据单位id过滤不属于自己单位的软替
//             */
//            List<SoftUnit> softUnits = units.stream().filter(softUnit -> softUnit.getId() == unitId).collect(toList());
//            if(softUnits.size() != 0){
//                softwork.setUnits(softUnits);
//                /*
//                根据id查询技术路线与产品映射表
//                */
//                List<Integer> techs = techProduceDao.findProduce(softwork.getTechId());
//                softwork.setTechs(techDao.findAllById(techs));
//                softs.add(softwork);
//            }
//        }
//
//        return ServerResponse.success(softs);
//    }

    /**
     * 根据id删除软件，逻辑删除
     * 1、删除软件
     * 2、解绑，单位、计划、文件、技术路线
     * softWork id
     * @return 成功
     */
//    public ServerResponse deleteSoftWork(SoftWork softWork) {
//        int id = softWork.getId();
//        SoftWork soft = sofeWorkDao.getOne(id);
//        /*
//        删除软件
//         */
//        soft.setDeleted(true);
//        /*
//        解绑技术路线
//         */
//        soft.setTechId(null);
//        /*
//         解绑计划
//         */
//        soft.setPlanId(null);
//        /*
//         * 解绑单位
//         */
//        List<SoftUnit> units = softUnitDao.findSoftUnitsBySoftIdAndState(id,1);
//        for (SoftUnit softUnit:units) {
//            softUnit.setState(0);
//        }
//        return ServerResponse.success("删除软件成功");
//    }


    @Transactional(rollbackFor = Exception.class)
    public void saveAll(List<SoftWork> softWorks, Integer projectId) {
        if (softWorks!=null&&softWorks.size()>0&&projectId!=null){
            for (SoftWork softWork:softWorks){
                softWork.setProjectId(projectId);
                save(softWork);
            }

        }
    }
    @Transactional(rollbackFor = Exception.class)
    public void save(SoftWork softWork) {
        sofeWorkDao.save(softWork);
    }

    public PageResult<SoftWork> search(BaseRequest<SoftWork> baseRequest) {
        SoftWork softWork = baseRequest.getT();
        Integer projectId = softWork.getProjectId();

        Specification<SoftWork> specifications = Specifications.<SoftWork>and()
                .eq( "projectId",projectId)
                .like(!StringUtils.isEmpty(softWork.getName()),"name","%"+softWork.getName()+"%")
                .build();
        Integer page = baseRequest.getPage();
        Integer pageSize = baseRequest.getPageSize();
        if (page==null || page<=0){
            page = 1;
        }
        if (pageSize==null || pageSize<=0){
            pageSize = 10;
        }
        Pageable pageable = PageRequest.of(page-1, pageSize, Sort.Direction.DESC, "id");
        Long count = sofeWorkDao.count(specifications);
        List<SoftWork> softWorks = sofeWorkDao.findAll(specifications,pageable).getContent();
        return new PageResult<>(page,pageSize,count,softWorks);
    }
}
