package com.zjty.project.state.server.service;

import com.github.wenhao.jpa.Specifications;
import com.zjty.project.state.server.dao.TechDao;
import com.zjty.project.state.server.pojo.Produce;
import com.zjty.project.state.server.pojo.Tech;
import com.zjty.project.state.server.pojo.TechProduce;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.PageResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @program: state
 * @description:
 * @author: LiuJie
 * @create: 2020-02-27 12:44
 **/
@Service
public class TechService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private TechDao techDao;
    @Autowired
    private TechProduceService techProduceService;
    @Autowired
    private ProduceService produceService;

    @Transactional(rollbackFor = Exception.class)
    public void add(Tech tech) {
        tech = techDao.save(tech);
        List<Integer> produceList = tech.getProduceList();
        ArrayList<TechProduce> list = new ArrayList<>();
        for (Integer a:produceList){
            list.add(new TechProduce(null,tech.getId(),a));
        }
        techProduceService.addAll(list);
    }


    public PageResult<Tech> search(BaseRequest<Tech > baseRequest) {
        Tech tech = baseRequest.getT();
        Specification<Tech> specifications = null;
        if (tech==null){
            specifications = Specifications.<Tech>and()
                    .build();
        }else {
            Integer produceId = tech.getProduceId();
            List<Integer> techIds = new ArrayList<>();
            Object[] array = techIds.toArray();

            if (produceId!=null&&produceId>0){
                techIds = techProduceService.findTechByProduce(produceId);
                array = techIds.toArray();
            }
            specifications = Specifications.<Tech >and()
                    .like(tech.getName()!=null && !Objects.equals(tech.getName(), ""),"name","%"+tech.getName()+"%")
                    .in(array!=null && array.length>0,"id",array)
                    .build();
        }
        Integer page = baseRequest.getPage();
        Integer pageSize = baseRequest.getPageSize();
        if (page==null || page<=0){
            page = 1;
        }
        if (pageSize==null || pageSize<=0){
            pageSize = 10;
        }
        Pageable pageable = PageRequest.of(page-1, pageSize, Sort.Direction.DESC, "id");
        Long count = techDao.count(specifications);
        List<Tech > techList = techDao.findAll(specifications,pageable).getContent();
        for (Tech t:techList){
            List<Produce> produceList = produceService.findByTech(t.getId());
            t.setProducies(produceList);
        }
        return new PageResult<Tech >(page,pageSize,count,techList);
    }

    public List<Tech> findAll() {
        List<Tech> all = techDao.findAll();
        for (Tech tech:all){
            List<Produce> list = new ArrayList<>();
            List<Integer> produceIds = techProduceService.findProduceByTech(tech.getId());
            for (Integer p:produceIds){
                Produce produce = produceService.findById(p);
                list.add(produce);
            }
            tech.setProducies(list);
        }
        return all;
    }

    public Tech findById(Integer id) {
        Optional<Tech> optional = techDao.findById(id);
        return optional.isPresent()?optional.get():null;
    }

    @Transactional(rollbackFor = Exception.class)
    public void update(Tech tech) {
        Integer id = tech.getId();
        if (id!=null&&id>0){
            techDao.saveAndFlush(tech);
            techProduceService.update(tech);
        }
    }

    public Tech findTech(Integer techId) {
        Tech tech = findById(techId);
        if (tech!=null){
            List<Produce> list = new ArrayList<>();
            List<Integer> produceIds = techProduceService.findProduceByTech(techId);
            for (Integer p:produceIds){
                Produce produce = produceService.findById(p);
                list.add(produce);
            }
            tech.setProducies(list);
        }
        return tech;
    }
}
