package com.zjty.project.state.utils;

import com.zjty.project.state.server.pojo.user.User;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.scheduling.annotation.Scheduled;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;


public class LoginedUserPool {
    private static HashMap<String, MyUser> userHashMap = new HashMap<>();

    public static String put(User user){
        String uuid = UUIDUtils.getUUID();
        userHashMap.put(uuid,new MyUser(user,0));
        return uuid;
    }

    public static User get(String uuid){
        if(uuid==null){
            return null;
        }
        User user = userHashMap.get(uuid).refresh();
        return user;
    }

    @Scheduled(cron = "0 0/1 * * * ? ")
    public void check(){
        Iterator<Map.Entry<String,MyUser>> it = userHashMap.entrySet().iterator();
        while (it.hasNext()){
            Map.Entry<String, MyUser> next = it.next();
            System.out.println(next.getValue().user.getId());
            if(next.getValue().add()>5){
                it.remove();
            }
        }
    }


    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    private static class MyUser{
        private User user;
        private int num;
        private User refresh(){
            this.num = 0;
            return this.user;
        }
        private int add(){
            return ++this.num;
        }
    }
}
