package com.zjty.project.inspect.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <h4>Description : 浏览器难度</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-03-05 19:23
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "浏览器难度")
public class BrowserDifficulty {
    /**
     * 系统评估
     */
    private double systemEvaluation;

    /**
     * 额外信息
     */
    private double message;

    /**
     * 综合难度
     */
    private double difficulty;

    /**
     * 工作量
     */
    private double load;

    /**
     * 样式
     */
    @ApiModelProperty(value = "样式",example = "1")
    private Integer style;

    /**
     * api
     */
    @ApiModelProperty(value = "api",example = "1")
    private Integer api;

    /**
     * 插件
     */
    @ApiModelProperty(value = "插件",example = "1")
    private Integer plugInUnit;

    /**
     * 用户额外需求
     */
    /**
     * 地理信息系统 int 1：是 2：否
     */
    @ApiModelProperty(value = "地理信息系统 int 1：是 2：否",example = "1")
    private Integer geography;
    /**
     * 调用外设
     */
    @ApiModelProperty(value = "调用外设",example = "1")
    private Integer peripheral;

    /**
     *动画
     */
    @ApiModelProperty(value = "动画",example = "1")
    private Integer animation;

    /**
     * 3d展示
     */
    @ApiModelProperty(value = "3d展示",example = "1")
    private Integer threeD;

    /**
     * 公文显现与编辑
     */
    @ApiModelProperty(value = "公文显现与编辑",example = "1")
    private Integer document;

    /**
     * 多媒体
     */
    @ApiModelProperty(value = "多媒体",example = "1")
    private Integer media;

    /**
     * Flash
     */
    @ApiModelProperty(value = "Flash",example = "1")
    private Integer flash;

    /**
     * 其他
     */
    @ApiModelProperty(value = "其他",example = "1")
    private Integer otherDemand;


}
