package com.zjty.project.inspect.service.impl;

import com.zjty.project.inspect.dao.ReportDao;
import com.zjty.project.inspect.dao.TechnologyDao;
import com.zjty.project.inspect.entity.CustomPage;
import com.zjty.project.inspect.entity.InspectParameter;
import com.zjty.project.inspect.entity.Report;
import com.zjty.project.inspect.entity.ReportManage;
import com.zjty.project.inspect.service.ParameterService;
import com.zjty.project.inspect.service.ReportService;
import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

import java.util.Map;
import java.util.Optional;

/**
 * @author Mcj
 * @date 2020-02-27 10:35
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class ReportServiceImpl implements ReportService {

    @Autowired
    private TechnologyDao technologyDao;

    @Autowired
    private ParameterService parameterService;

    @Autowired
    private ReportDao reportDao;

    //执行静态化
    private String generateHtml(String templateContent, Map model ){
        //创建配置对象
        Configuration configuration = new Configuration(Configuration.getVersion());
        //创建模板加载器
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        stringTemplateLoader.putTemplate("template",templateContent);
        //向configuration配置模板加载器
        configuration.setTemplateLoader(stringTemplateLoader);
        //获取模板
        try {
            Template template = configuration.getTemplate("template");
            //调用api进行静态化
            String content = FreeMarkerTemplateUtils.processTemplateIntoString(template, model);
            return content;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }


    @Override
    public CustomPage<Report> findReportByPage(int page) {
        PageRequest of = PageRequest.of(page - 1, 10);
        Page<Report> all = reportDao.findAll(of);
        CustomPage<Report> reportPage = new CustomPage<>();
        reportPage.setTotalElement((int) all.getTotalElements());
        reportPage.setTotalPage(all.getTotalPages());
        reportPage.addAll(all.getContent());
        return reportPage;
    }

    @Override
    public ReportManage findReportById(String id) {
        Optional<Report> report = reportDao.findById(id);
        ReportManage reportManage = new ReportManage();
        if(report.isPresent()){
            reportManage.setReport(report.get());
            InspectParameter inspectParameter = parameterService.getParameterById(report.get().getId());
            reportManage.setInspectParameter(inspectParameter);
        }
        return reportManage;
    }

    @Override
    public void saveReport(Report report) {
        reportDao.save(report);
    }
}
