package com.zjty.project.state.config.feign;

import com.zjty.project.state.server.pojo.person.Personnel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @program: bserver
 * @description: person
 * @author: LiuJie
 * @create: 2019-12-13 14:00
 **/
@FeignClient(value="PERSON",configuration = PersonnelFallback.class)
public interface PersonnelClient {
    @RequestMapping(value = "/personnel/getLogin/{sesionId}",method = RequestMethod.GET)
    public Personnel getLogin(@PathVariable("sesionId") String sesionId);
}
