package com.zjty.project.state.config.webmvc;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.ArrayList;
import java.util.List;

/**
 * @program: bserver
 * @description: webMVC层的相关配置在这里，在这里之所以使用过时的"WebMvcConfigurerAdapter",
 *                 而不使用SpringBoot推荐的"WebMvcConfigurationSupport"，是因为使用后者“WebMvcConfigurationSupport”，
 *                 无法使用Swagger2的自动化生成接口的功能，后期研究如何解决吧;
 *
 *                 漫漫无期，后来我发现，前者"WebMvcConfigurerAdapter"，在Spring5.X后就过期了，不推荐使用，
 *                 而使用“WebMvcConfigurationSupport”，会导致许多的自动配置失效，这是因为在WebMvcAutoConfiguration上
 *                 有一个注解@ConditionalOnMissingBean(WebMvcConfigurationSupport.class)
 *                 意思就是WebMvcAutoConfiguration生效的条件是没有WebMvcConfigurationSupport这个类，但是我们现在继承了这个类，
 *                 所以就导致WebMvcAutoConfiguration自动配置失效，需要我们自己手动配置
 *                 在这里我主要配置类如下几个映射（见重写的addResourceHandlers方法）；
 *
 *                 再后来，我又发现SpringBoot又推荐我们通过实现"WebMvcConfigurer"，
 *                 这样就可以像以前使用WebMvcConfigurerAdapter一样，避免了自动配置失效的问题，
 *                 同样可以达到我们的目的。
 *
 * @author: LiuJie
 * @create: 2019-05-15 11:27
 **/
@Configuration
public class MyWebAppConfigurer implements WebMvcConfigurer {
// public class MyWebAppConfigurer extends WebMvcConfigurationSupport {
// public class MyWebAppConfigurer extends WebMvcConfigurerAdapter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 添加拦截器
     * @param registry
     */
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        //注册自定义拦截器，添加拦截路径和排除拦截路径
//        registry.addInterceptor(this.getInterceptorConfig()).addPathPatterns("/**");
//        registry.addInterceptor(loginInterceptorConfig).addPathPatterns("/**");
        logger.info("注册拦截器成功");
    }


    /**
     * 利用fastjson替换掉jackson，且解决中文乱码问题
     */
    @Override
    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        FastJsonHttpMessageConverter fastJsonHttpMessageConverter = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setSerializerFeatures(SerializerFeature.DisableCircularReferenceDetect);
//        fastJsonConfig.setSerializerFeatures(SerializerFeature.PrettyFormat);
        List<MediaType> fastMediaTypes = new ArrayList<>();
        fastMediaTypes.add(MediaType.APPLICATION_JSON_UTF8);
        fastJsonHttpMessageConverter.setSupportedMediaTypes(fastMediaTypes);
        fastJsonHttpMessageConverter.setFastJsonConfig(fastJsonConfig);
        converters.add(fastJsonHttpMessageConverter);
    }

//    @Override
//    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
//        super.configureMessageConverters(converters);
//		/*
//		 * 1、需要先定义一个 convert 转换消息的对象;
//		 * 2、添加fastJson 的配置信息，比如：是否要格式化返回的json数据;
//		 * 3、在convert中添加配置信息.
//		 * 4、将convert添加到converters当中.
//		 *
//		 */
//        // 1、需要先定义一个 convert 转换消息的对象;
//        FastJsonHttpMessageConverter fastConverter = new FastJsonHttpMessageConverter();
//
//        //2、添加fastJson 的配置信息，比如：是否要格式化返回的json数据;
//        FastJsonConfig fastJsonConfig = new FastJsonConfig();
//        fastJsonConfig.setSerializerFeatures(SerializerFeature.PrettyFormat);
//
//        //解决中文乱码问题：在方法内部添加这段代码
//        List<MediaType> fastMediaTypes = new ArrayList<>();
//        fastMediaTypes.add(MediaType.APPLICATION_JSON_UTF8);
//        fastConverter.setSupportedMediaTypes(fastMediaTypes);
//
//        //3、在convert中添加配置信息.
//        fastConverter.setFastJsonConfig(fastJsonConfig);
//        //4、将convert添加到converters当中.
//        converters.add(fastConverter);
//    }

    /**
     * 添加跨域处理:那么这里和网关只需要配以一个就OK了，不能两个地方都配，否则失效
     * @param registry
     */
    @Override
    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**")

                .allowedOrigins("*")
                .allowedMethods("POST","GET","PUT","OPTIONS","DELETE")
                .maxAge(3600)
                .allowCredentials(true);
    }

    /**
     * 静态资源访问路径
     * @param registry
     */
    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        //将所有/static/** 访问都映射到classpath:/static/ 目录下
        registry.addResourceHandler("/static/**")
                .addResourceLocations("classpath:/static/")
                .addResourceLocations("classpath:file:./static/")
                .addResourceLocations("classpath:/uplaods/");

    }



}