package com.zjty.project.state.server.controller;

import com.zjty.project.state.base.exception.MyException;
import com.zjty.project.state.base.response.ResponseCode;
import com.zjty.project.state.base.response.ServerResponse;
import com.zjty.project.state.server.pojo.File;
import com.zjty.project.state.server.pojo.user.User;
import com.zjty.project.state.server.service.FileService;
import com.zjty.project.state.utils.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;

/**
 * <h4>Description : demo</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-02-27 13:43
 */
@Api(tags = "FileController文件上传接口")
@RestController
@RequestMapping("/file")
public class FileController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private final FileService fileService;

    @Autowired
    public FileController(FileService fileService) {
        this.fileService = fileService;
    }


//    @ApiOperation(value = "上传文件", notes = "上传文件")
//    @PostMapping("/upload")
//    public ServerResponse uploadFile(MultipartHttpServletRequest request, File file){
//        try {
//
//            File file1 = fileService.uploadFile(request, file);
//            return ServerResponse.success(file1);
//        }catch (Exception e){
//            String info = ExceptionMessage.getStackTraceInfo(e);
//            logger.error("上传文件失败：{}",info);
//            throw new MyException(ResponseCode.SERVER_ERROR);
//        }
//
//    }
//
//
//    @ApiOperation(value = "删除文件", notes = "删除文件")
//    @DeleteMapping("/{fileId}")
//    public ServerResponse deletaFile(@PathVariable("fileId")Integer fileId){
//        try {
//            return fileService.deletaFile(fileId);
//        }catch (Exception e){
//            String info = ExceptionMessage.getStackTraceInfo(e);
//            logger.error("删除文件失败：{}",info);
//            throw new MyException(ResponseCode.SERVER_ERROR);
//        }
//    }
//
//    @ApiOperation(value = "分页查看文件", notes = "根据条件和页码查看文件列表")
//    @PostMapping("/{page}/{size}")
//    public ServerResponse findFile(@RequestBody File file, @PathVariable("fileId") Integer page,@PathVariable("size")Integer size){
//        return fileService.findFile(file,page,size);
//    }



    @ApiOperation(value = "项目文件清单分页查询", notes = "项目文件清单分页查询")
    @RequestMapping(value = "/search", method = RequestMethod.POST)
    public ServerResponse search(@RequestBody BaseRequest<File> baseRequest){
        try {
            File file = baseRequest.getT();
            if (file!=null){
                Integer projectId = file.getProjectId();
                if (projectId!=null){
                    PageResult<File> pageResult= fileService.search(baseRequest);
                    return ServerResponse.success(pageResult);
                }else {
                    throw new MyException(ResponseCode.PROJECT_ID_IS_NULL);
                }
            }else {
                throw new MyException(ResponseCode.PROJECT_ID_IS_NULL);
            }
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("项目文件清单分页查询失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }

    @ApiOperation(value = "上传项目文件", notes = "上传项目文件")
    @RequestMapping(value = "/upload/{id}", method = RequestMethod.POST)
    public ServerResponse upload(HttpServletRequest request,@PathVariable("id")Integer id, @RequestParam("file") MultipartFile multipartFile) {
        try {
            String loginSession = request.getHeader("session");
            User user = LoginedUserPool.get(loginSession);
            if (user!=null){
                fileService.upload(id,multipartFile,user);
                return ServerResponse.success(ResponseCode.OK);
            }else {
                throw new MyException(ResponseCode.USER_NOT_LOGIN);
            }
        } catch (MyException myException) {
            throw myException;
        }catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("上传项目文件失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }

    }


}
