package com.zjty.project.state.server.controller;

import com.zjty.project.state.base.exception.MyException;
import com.zjty.project.state.base.response.ResponseCode;
import com.zjty.project.state.base.response.ServerResponse;
import com.zjty.project.state.server.pojo.SoftWork;
import com.zjty.project.state.server.service.SoftWorkService;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.ExceptionMessage;
import com.zjty.project.state.utils.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * <h4>Description : demo</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-02-27 14:04
 */
@Api(tags = "softWorkController软替任务")
@RestController
@RequestMapping("/soft")
public class SoftWorkController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private final SoftWorkService softWorkService;

    @Autowired
    public SoftWorkController(SoftWorkService softWorkService) {
        this.softWorkService = softWorkService;
    }

//    @ApiOperation(value = "新增软替任务",notes = "新增软替任务")
//    @PutMapping
//    public ServerResponse addSoftWork(@RequestBody SoftWork softWork){
//        return softWorkService.addSoftWork(softWork);
//    }
//
//    @ApiOperation(value = "分页查询软替任务",notes = "分页查询自己单位的软替任务")
//    @PostMapping("/search/{unitId}")
//    public ServerResponse findSoftWork(@RequestBody BaseRequest<SoftWork> baseRequest, @PathVariable("unitId") Integer unitId){
//        return softWorkService.findSoftWork(baseRequest,unitId);
//    }
//
//    @ApiOperation(value = "软替任务删除",notes = "删除软替任务")
//    @DeleteMapping
//    public ServerResponse deleteSoftWork(@RequestBody SoftWork softWork) {
//        return softWorkService.deleteSoftWork(softWork);
//    }


    @ApiOperation(value = "项目软替清单分页查询", notes = "项目软替清单分页查询")
    @RequestMapping(value = "/search", method = RequestMethod.POST)
    public ServerResponse search(@RequestBody BaseRequest<SoftWork> baseRequest){
        try {
            SoftWork softWork = baseRequest.getT();
            if (softWork!=null){
                Integer projectId = softWork.getProjectId();
                if (projectId!=null){
                    PageResult<SoftWork> pageResult= softWorkService.search(baseRequest);
                    return ServerResponse.success(pageResult);
                }else {
                    throw new MyException(ResponseCode.PROJECT_ID_IS_NULL);
                }
            }else {
                throw new MyException(ResponseCode.PROJECT_ID_IS_NULL);
            }
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("项目产品清单分页查询失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }

}
