package com.zjty.project.state.server.controller;

import com.zjty.project.state.base.exception.MyException;
import com.zjty.project.state.base.response.ResponseCode;
import com.zjty.project.state.base.response.ServerResponse;
import com.zjty.project.state.server.pojo.Tech;
import com.zjty.project.state.server.service.TechService;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.ExceptionMessage;
import com.zjty.project.state.utils.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: demo
 * @description:
 * @author: LiuJie
 * @create: 2020-02-13 16:04
 **/
@Api(description = "TechController技术路线接口")
@RestController
@RequestMapping("/tech")
public class TechController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private TechService techService;

    @ApiOperation(value = "新建技术路线", notes = "新建技术路线，同时选着该技术路线产品组合")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ServerResponse<String> add(@RequestBody Tech tech) throws Exception{
        try {
            techService.add(tech);
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("新建技术路线失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
        return ServerResponse.success("新建技术路线成功。");
    }

    @ApiOperation(value = "修改技术路线的产品组合", notes = "修改技术路线的产品组合")
    @RequestMapping(value = "/update", method = RequestMethod.PUT)
    public ServerResponse update(@RequestBody Tech tech) throws Exception{
        try {
            techService.update(tech);
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("修改技术路线的产品组合失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
        return ServerResponse.success("修改成功。");
    }


    @ApiOperation(value = "技术路线分页查询", notes = "技术路线分页查询：根据技术路线名、角色、单位查询技术路线列表")
    @RequestMapping(value = "/search", method = RequestMethod.POST)
    public ServerResponse search(@RequestBody BaseRequest<Tech> baseRequest) throws Exception{
        try {
            PageResult<Tech> pageResult= techService.search(baseRequest);
            return ServerResponse.success(pageResult);
        }catch (MyException myException){
            String info = ExceptionMessage.getStackTraceInfo(myException);
            logger.error("技术路线分页查询失败:{}",info);
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("技术路线分页查询失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }

    @ApiOperation(value = "获取所有技术路线列表", notes = "获取所有技术路线列表：查询所有单位")
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    public ServerResponse findAll(){
        try {
            List<Tech> list= techService.findAll();
            return ServerResponse.success(list);
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("获取所有技术路线列表失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }


}
