package com.zjty.project.state.server.dao;

import com.zjty.project.state.server.pojo.TechProduce;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;

public interface TechProduceDao extends JpaRepository<TechProduce,Integer> ,JpaSpecificationExecutor {


    @Query("select t.produceId from TechProduce t where t.techId=:techId")
    List<Integer> findProduce(@Param(value = "techId") Integer techId);

    @Query("select t.techId from TechProduce t where t.produceId=:produceId")
    List<Integer> findTech(@Param(value = "produceId") Integer produceId);

    void deleteAllByTechId(Integer techId);


}
