package com.zjty.project.state.server.pojo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.util.Date;

//评价表
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Evaluate {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Integer id;
    @ApiModelProperty("标题")
    private String title;
    @ApiModelProperty("产品Id")
    private Integer produceId;
    @ApiModelProperty("人Id")
    private Integer personId;
    @ApiModelProperty("评价人ID")
    private Integer userId;
    @ApiModelProperty("单位ID")
    private Integer unitId;
    @ApiModelProperty("评分")
    private Integer score;
    @ApiModelProperty("评价时间")
    private Date time;
    @ApiModelProperty("审核人ID")
    private Integer checker;
    @ApiModelProperty("审核内容")
    private String checkContent;
    @ApiModelProperty("审核是否通过1：通过，0：未审核，-1：未通过")
//    private Boolean checkSuccess;
    private Integer status;

}
