package com.zjty.project.state.server.pojo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

//微服务接口表
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MicroServerInterface {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private int id;

    /**
     * 所属微服务ID
     */
    private int serverId;

    /**
     * 接口路径
     */
    private String path;

    /**
     * 接口功能描述
     */
    private String des;
}
