package com.zjty.project.state.server.pojo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.List;

/**
 * @program: state
 * @description: 产品实体类
 * @author: LiuJie
 * @create: 2020-02-11 11:56
 **/
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Produce {
    @ApiModelProperty("主键")
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    @ApiModelProperty("产品名称")
    private String name;
    @ApiModelProperty("产品分类1:软件，2：硬件")
    private Integer type;
    @ApiModelProperty("产品类型1:服务器、2CPU、3操作系统、4数据库、5中间件、6其他")
    private Integer form;
    @ApiModelProperty("产品型号")
    private String model;
    @ApiModelProperty("厂商")
    private String producer;
    @ApiModelProperty("准入状态1:已准入、-1:未被准入")
    private Integer status=-1;
    @Transient
    @ApiModelProperty("查询的技术路线id")
    private Integer techId;
    @Transient
    @ApiModelProperty("相关的技术路线")
    private Tech tech;
    @Transient
    @ApiModelProperty("相关的技术路线")
    private List<Tech> techList;
    @Transient
    @ApiModelProperty("周傲雪要的")
    private Integer expect;
}
