package com.zjty.project.state.server.pojo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.List;

//技术路线表
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Tech {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Integer id;
    @ApiModelProperty("技术路线名称")
    private String name;
    @ApiModelProperty("技术路线状态（未删除、已删除）")
    private Integer status;
    @ApiModelProperty("技术路线应用次数")
    private Integer num=0;
    @Transient
    @ApiModelProperty("技术路线产品组合Id")
    private List<Integer> produceList;
    @Transient
    @ApiModelProperty("技术路线产品组合")
    private List<Produce> producies;


    @Transient
    @ApiModelProperty("查询的产品id")
    private Integer produceId;



}
