package com.zjty.project.state.server.pojo.complain;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * @program: state
 * @description: 投诉实体类
 * @author: LiuJie
 * @create: 2020-03-04 09:39
 **/
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Complain {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Integer id;
    @ApiModelProperty("投诉对象1.集成商、2.监理方3.开发商4.硬件产品5.软件产品")
    private Integer target;
    @ApiModelProperty("产品Id")
    private Integer produceId;
    @Transient
    @ApiModelProperty("产品名称")
    private String produceName;
    @ApiModelProperty("投诉类型1.服务质量、2.服务态度、3.响应速度、4.其他")
    private Integer type;
    @ApiModelProperty("投诉人ID")
    private Integer userId;
    @Transient
    @ApiModelProperty("投诉人名称")
    private String userName;
    @ApiModelProperty("是否匿名投诉1：匿名，-1：不匿名")
    private Integer anonymity=-1;
    @ApiModelProperty("单位ID")
    private Integer unitId;
    @Transient
    @ApiModelProperty("单位名称")
    private String unitName;
    @ApiModelProperty("项目ID")
    private Integer projectId;
    @Transient
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("投诉电话")
    private String phone;
    @ApiModelProperty("投诉内容")
    private String content;
    @ApiModelProperty("投诉时间")
    private Date time;
    @Transient
    @ApiModelProperty("最新回复时间")
    private Date replyTime;
    @Transient
    @ApiModelProperty("投诉回复历史")
    private List<Reply> replyList;
    @Transient
    @ApiModelProperty("投诉回复内容")
    private String replyContent;
    @ApiModelProperty("是否重要1：是，-1：否")
    private Integer sign=-1;
    @ApiModelProperty("是否置顶1：是，-1：否")
    private Integer stick=-1;
//    @ApiModelProperty("审核人ID")
//    private Integer checker;
//    @ApiModelProperty("审核内容")
//    private String checkContent;
//    @ApiModelProperty("审核是否通过1：通过，0：未审核，-1：未通过")
////    private Boolean checkSuccess;
//    private Integer status;

}
