package com.zjty.project.state.server.pojo.complain;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.util.Date;

/**
 * @program: state
 * @description: 投诉回复
 * @author: LiuJie
 * @create: 2020-03-04 10:39
 **/
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Reply {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Integer id;
    @ApiModelProperty("投诉Id")
    private Integer complainId;
    @ApiModelProperty("回复时间")
    private Date time;
    @ApiModelProperty("回复内容")
    private String content;



}
