package com.zjty.project.state.server.service;

import com.alibaba.fastjson.JSON;
import com.zjty.project.state.server.pojo.TblFixChange;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @program: demo
 * @description:
 * @author: LiuJie
 * @create: 2020-02-13 16:06
 **/
@Service
public class GroupConfigService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 批量导入（批量添加）
     */
    private static final String XLS = "xls";
	private static final String XLSK = "xlsx";//定义全局的常量值

    @SuppressWarnings("resource")
    public Map<String, Object> importExcel(MultipartFile file) throws Exception {
        List<TblFixChange> list = new ArrayList<TblFixChange>();
        Map<String, Object> rsultMap = new HashMap<String, Object>();


        Workbook workbook = null;
        String fileName = file.getOriginalFilename();
        if(fileName.endsWith(XLS)) {
            //2003
            try {
                workbook = new HSSFWorkbook(file.getInputStream());
            } catch (Exception e) {
                e.printStackTrace( );
            }

        }else if(fileName.endsWith(XLSK)) {
            try {
                //2007
                workbook = new XSSFWorkbook(file.getInputStream());
            } catch (Exception e) {
                e.printStackTrace( );
            }
        }else {
            throw new Exception("文件不是Excel文件");
        }
        Sheet sheet = workbook.getSheet("Sheet1");
        System.out.println(sheet == null);
        int rows = sheet.getLastRowNum();//指定行数。一共多少+
        System.out.println("rows:"+rows);
        if(rows==0) {
            throw new Exception("请填写行数");
        }

        for (int i = 1; i < rows+1; i++) {
            //读取左上端单元格
            Row row = sheet.getRow(i);
            //行不为空
            if(row != null) {
                //读取cell
                TblFixChange tblFixChange = new TblFixChange();
                //手机号
                String phone = getCellValue(row.getCell(0));
                tblFixChange.setPhone(phone);
                //车牌号
                String catNumber = getCellValue(row.getCell(1));
                tblFixChange.setCarNumber(catNumber);
                //组的id
                String groupId = getCellValue(row.getCell(2));

                tblFixChange.setGroupId(groupId);
//               SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//				String time = sdf.format(new Date());
                String createTime = getCellValue(row.getCell(3));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date time = sdf.parse(createTime);
                tblFixChange.setCreateTime(time);
                tblFixChange.setModifyTime(time);
                list.add(tblFixChange);//把实数据放入集合里
            }
        }
        try {
//            groupConfigDao.addBatchMembers(list);//批量添加 (执行sql语句批量增加)
            for (int i=0;i<list.size();i++){
                TblFixChange fixChange = list.get(i);
                System.out.println(JSON.toJSONString(fixChange));
            }
            rsultMap.put("status", 1);
            rsultMap.put("data", "导入数据成功");
        } catch (Exception e) {
            rsultMap.put("status", -1);
            rsultMap.put("data", "导入数据异常");
        }

        return rsultMap;
    }

    //获取Cell内容
    private String getCellValue(Cell cell) {
        String value = "";
        if(cell != null) {
            //以下是判断数据的类型
            switch (cell.getCellType()) {
                case HSSFCell.CELL_TYPE_NUMERIC://数字
                    value = cell.getNumericCellValue() + "";
                    if(HSSFDateUtil.isCellDateFormatted(cell)) {
                        Date date = cell.getDateCellValue();
                        if(date != null) {
                            value = new SimpleDateFormat("yyyy-MM-dd").format(date);
                        }else {
                            value = "";
                        }
                    }else {
                        value = new DecimalFormat("0").format(cell.getNumericCellValue());
                    }
                    break;
                case HSSFCell.CELL_TYPE_STRING: //字符串
                    value = cell.getStringCellValue();
                    break;
                case HSSFCell.CELL_TYPE_BOOLEAN: //boolean
                    value = cell.getBooleanCellValue() + "";
                    break;
                case HSSFCell.CELL_TYPE_FORMULA: //公式
                    value = cell.getCellFormula() + "";
                    break;
                case HSSFCell.CELL_TYPE_BLANK: //空值
                    value = "";
                    break;
                case HSSFCell.CELL_TYPE_ERROR: //故障
                    value = "非法字符";
                    break;
                default:
                    value = "未知类型";
                    break;
            }
        }
        return value.trim();
    }
}
