package com.zjty.project.state.server.service;

import com.zjty.project.state.server.dao.RoleAuthorityDao;
import com.zjty.project.state.server.pojo.user.Role;
import com.zjty.project.state.server.pojo.user.RoleAuthority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @program: state
 * @description:
 * @author: LiuJie
 * @create: 2020-02-26 10:27
 **/
@Service
public class RoleAuthorityService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RoleAuthorityDao roleAuthorityDao;

    @Transactional(rollbackFor = Exception.class)
    public void add(List<RoleAuthority> list){
        roleAuthorityDao.saveAll(list);
    }

    /**
     * @Description: 根据角色Id,查询该角色下的权限组合Id
     * @Param:
     * @return:
     * @Author: LiuJie
     * @Date: 2020/2/27
     */
    public List<Integer> findAuthorityByRole(Integer roleId) {
//        return roleAuthorityDao.findAuthority(roleId);
        List<Integer> list = new ArrayList<>();
        List<RoleAuthority> roleAuthorityList = roleAuthorityDao.findAllByRoleId(roleId);
        for (RoleAuthority roleAuthority:roleAuthorityList){
            list.add(roleAuthority.getAuthorityId());
        }
        return list;
    }

    @Transactional(rollbackFor = Exception.class)
    public void update(Role role) {
        Integer id = role.getId();
        if (id!=null){
            deleteAllByRoleId(id);
            List<RoleAuthority> list = new ArrayList<>();
            List<Integer> authorityList = role.getAuthorityList();
            for (Integer authorityId:authorityList){
                list.add(new RoleAuthority(null,id,authorityId));
            }
            add(list);
        }
    }

    private void deleteAllByRoleId(Integer roleId) {
        roleAuthorityDao.deleteAllByRoleId(roleId);
    }
}
