package com.zjty.project.state.server.service;

import com.github.wenhao.jpa.Specifications;
import com.zjty.project.state.server.dao.UnitDao;
import com.zjty.project.state.server.pojo.Unit;
import com.zjty.project.state.server.pojo.properties.Properties;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.ExceptionMessage;
import com.zjty.project.state.utils.GetCellValueUtils;
import com.zjty.project.state.utils.PageResult;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.util.*;


/**
 * @program: state
 * @description:
 * @author: LiuJie
 * @create: 2020-02-27 09:53
 **/
@Service
public class UnitService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private UnitDao unitDao;
    
    /**
     * 批量导入（批量添加）
     */
    private static final String XLS = "xls";
    private static final String XLSK = "xlsx";//定义全局的常量值

    @Transactional(rollbackFor = Exception.class)
    public Map<String, Object> importExcel(MultipartFile file) throws Exception {
        List<Unit> list = new ArrayList<>();
        Map<String, Object> rsultMap = new HashMap<>();
        try {
            Workbook workbook = null;
            String fileName = file.getOriginalFilename();
            if(fileName.endsWith(XLS)) {
                //2003
                try {
                    workbook = new HSSFWorkbook(file.getInputStream());
                } catch (Exception e) {
                    e.printStackTrace( );
                }

            }else if(fileName.endsWith(XLSK)) {
                try {
                    //2007
                    workbook = new XSSFWorkbook(file.getInputStream());
                } catch (Exception e) {
                    e.printStackTrace( );
                }
            }else {
                throw new Exception("文件不是Excel文件");
            }
            Sheet sheet = workbook.getSheet("Sheet1");
            logger.info("sheet：{}",sheet==null);
            int rows = sheet.getLastRowNum();//指定行数。一共多少+
            logger.info("rows:"+rows);
            if(rows==0) {
                throw new Exception("请填写行数");
            }
            for (int i = 1; i < rows+1; i++) {
                //读取左上端单元格
                Row row = sheet.getRow(i);
                //行不为空
                if(row != null) {
                    //读取cell
                    Unit unit = new Unit();
                    //单位名称
                    String name = GetCellValueUtils.getCellValue(row.getCell(0));
                    unit.setName(name);
                    //单位分类
                    String type = GetCellValueUtils.getCellValue(row.getCell(1));
                    unit.setType(Integer.parseInt(type));
                    //单位地址
                    String address = GetCellValueUtils.getCellValue(row.getCell(2));
                    unit.setAddress(address);
                    //单位联系方式
                    String number = GetCellValueUtils.getCellValue(row.getCell(3));
                    unit.setNumber(number);
                    //单位负责人
                    String principal = GetCellValueUtils.getCellValue(row.getCell(4));
                    unit.setPrincipal(principal);
//               SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//				String time = sdf.format(new Date());
//                String createTime = GetCellValueUtils.getCellValue(row.getCell(3));
//                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
//                Date time = sdf.parse(createTime);
                    list.add(unit);//把实数据放入集合里
                }
            }
            try {
//            groupConfigDao.addBatchMembers(list);//批量添加 (执行sql语句批量增加)
                unitDao.saveAll(list);
                rsultMap.put("status", 1);
                rsultMap.put("data", "导入数据成功");
            } catch (Exception e) {
                rsultMap.put("status", -1);
                rsultMap.put("data", "导入数据异常");
                String error = ExceptionMessage.getStackTraceInfo(e);
                logger.error("导入数据异常error:{}",error);
            }
            return rsultMap;
        }catch (Exception e){
            String error = ExceptionMessage.getStackTraceInfo(e);
            logger.error("error:{}",error);
        }
        return rsultMap;
    }


    public List<Unit> findAll() {
        return unitDao.findAll();
    }

    public List<Unit> findAccess() {
        return unitDao.findAllByStatus(Properties.NUM_1);
    }

    @Transactional(rollbackFor = Exception.class)
    public void add(Unit Unit) {
        unitDao.save(Unit);
    }

    public PageResult<Unit> search(BaseRequest<Unit> baseRequest) {
        Specification<Unit> specifications = null;
        Unit unit = baseRequest.getT();
        if (unit==null){
            specifications = Specifications.<Unit>and()
                    .build();
        }else {
            specifications = Specifications.<Unit>and()
                    .like(unit.getName()!=null && !Objects.equals(unit.getName(), ""),"name","%"+unit.getName()+"%")
                    .eq(unit.getType()!=null && !Objects.equals(unit.getType(), ""),"type",unit.getType())
                    .eq(unit.getStatus()!=null && !Objects.equals(unit.getStatus(), ""),"status",unit.getStatus())
                    .build();
        }
        Integer page = baseRequest.getPage();
        Integer pageSize = baseRequest.getPageSize();
        if (page==null || page<=0){
            page = 1;
        }
        if (pageSize==null || pageSize<=0){
            pageSize = 10;
        }
        Pageable pageable = PageRequest.of(page-1, pageSize, Sort.Direction.DESC, "id");
        Long count = unitDao.count(specifications);
        List<Unit> roleList = unitDao.findAll(specifications,pageable).getContent();
        return new PageResult<>(page,pageSize,count,roleList);
    }


    public Unit findById(Integer id) {
        if (id==null){
            return null;
        }
        Optional<Unit> optional = unitDao.findById(id);
        Unit unit = optional.isPresent() ? optional.get() : null;
        return unit;
    }

    public String getName(Integer id) {
        Unit unit = findById(id);
        if (unit==null){
            return null;
        }
        return unit.getName();
    }

    public List<Unit> findByType(Integer type) {
        return unitDao.findAllByType(type);
    }
}
