package com.zjty.project.state.thread.task;


import com.zjty.project.state.config.websocket.WebSocketServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * @program: bserver
 * @description: 异步线程任务类
 * @author: LiuJie
 * @create: 2019-05-21 09:39
 **/

@Component
public class AsyncTask {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private WebSocketServer webSocketServer;

    @Value("${debugName}")
    private String debugName;
    @Value("${personName}")
    private String personName;

    /**
    * @Description: myTaskAsynPool即配置线程池的方法名，
     *  此处如果不写自定义线程池的方法名，会使用默认的线程池
    * @Param:
    * @return:
    * @Author: LiuJie
    * @Date: 2019/5/20
    */
    @Async("myTaskAsyncPool")
    public void doTask1(int i) throws InterruptedException{
    }
}