package com.zjty.project.state.utils;

import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

/**
 * <p>Description : debug-fromdebugserver
 * <p>Date : 2017/12/15 10:28
 * <p>@author : Matrix [xhyrzldf@foxmail.com]
 */
public class HttpUtils {

    public static String sendPost(String url, String jsonArgs) throws UnsupportedEncodingException {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        //设置请求体
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        //设置请求数据
        HttpEntity<String> formEntity = new HttpEntity<>(jsonArgs, headers);
        String result = restTemplate.postForObject(url, formEntity, String.class);
        return result;

    }

    public static String sendGet(String url) throws UnsupportedEncodingException {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        String result = restTemplate.getForObject(url , String.class);
        restTemplate.getForObject(url, String.class);
        return result;
    }

}
