package com.zjty.project.inspect.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * 依赖
 */
@NoArgsConstructor
@Data
@ApiModel(value = "依赖")
public class PomDependency implements Serializable {

    private String groupId = "";
    private String artifactId = "";
    private String gradle = "";
    /**
     * 1:前端依赖
     * 2:后端依赖
     */
    @ApiModelProperty(value = "前端依赖",example = "1")
    private Integer type = 2;

    /**
     * 1:支持
     * 2：不支持
     * 3：未知
     */
    @ApiModelProperty(value = "支持",example = "1")
    private Integer support;
}
