package com.zjty.project.state.base.response;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

/**
 * <p>Description : 异常结果枚举类,用于统一异常状态码与相关描述信息
 * @Date : 2017/12/13 0:51
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 */
@AllArgsConstructor
@NoArgsConstructor
@Getter
public enum ResponseCode {

//    /**
//     * 服务器成功返回用户请求的数据
//     */
//    OK(200, "[GET]：服务器成功返回用户请求的数据,返回资源对象"),
//
//    /**
//     * 用户新建或修改数据成功
//     */
//    CREATED(201, "[POST/PUT/PATCH]：用户新建或修改数据成功,返回新生成或修改的资源对象"),
//
//    /**
//     * 表示一个请求已经进入后台排队（异步任务)
//     */
//    ACCEPTED(202, "[*]：表示一个请求已经进入后台排队（异步任务)"),
//
//
//    /**
//     * 用户上传文件成功
//     */
    UPLOADED(203, "[POST]文件上传成功"),
//
//    /**
//     * 用户删除数据成功
//     */
//    NO_CONTENT(204, " [DELETE]：用户删除数据成功"),
//
//    /**
//     * 用户发出的请求有错误，服务器没有进行新建或修改数据的操作
//     */
//    INVALID_REQUEST(400, "[POST/PUT/PATCH]：用户发出的请求有错误，服务器没有进行新建或修改数据的操作"),
//    /**
//     * 表示用户没有权限（令牌、用户名、密码错误）
//     */
//    UNAUTHORIZED(401, " [*]：表示用户没有权限（令牌、用户名、密码错误）"),
//
//    /**
//     * 表示用户得到授权（与401错误相对），但是访问是被禁止的
//     */
//    FORBIDDEN(403, " [*] 表示用户得到授权（与401错误相对），但是访问是被禁止的"),
//
//    /**
//     * 用户发出的请求针对的是不存在的记录，服务器没有进行操作，该操作是幂等的
//     */
//    NOT_FOUND(404, " [*]：用户发出的请求针对的是不存在的记录，服务器没有进行操作"),
//
//    /**
//     * 非法参数，请求中附带的参数不符合要求规范
//     */
//    ILLEGAL_PARAMETER(405, "[*]：非法参数，请求中附带的参数不符合要求规范"),
//
//    /**
//     * 用户请求的格式不可得（比如用户请求JSON格式，但是只有XML格式）
//     */
//    NOT_ACCEPTABLE(406, " [GET]：用户请求的格式不可得（比如用户请求JSON格式，但是只有XML格式）"),
//
//    /**
//     * 用户的参数不得为空
//     */
//    NOT_NULL_PARAMETER(408, "传递的参数不能为空"),
//
//    /**
//     * 用户请求的资源被永久删除，且不会再得到的
//     */
//    GONE(413, "[GET]：用户请求的资源被永久删除，且不会再得到的"),
//
//    /**
//     * [PUT,PATCH,POST,DELETE]：操作没有成功，并没有数据发生变化
//     */
//    NO_CHANGED(414, "[PUT,PATCH,POST,DELETE]：操作没有成功，并没有数据发生变化"),
//
//    /**
//     * 创建一个对象时，发生一个验证错误
//     */
//    UNPROCESSABLE_ENTITY(422, "[POST/PUT/PATCH] 当创建一个对象时，发生一个验证错误"),
//
//    /**
//     * 服务器发生错误
//     */
//    INTERNAL_SERVER_ERROR(500, "服务器发生错误"),

    CONTINUE(100, "Continue"),
    SWITCHING_PROTOCOLS(101, "Switching Protocols"),
    PROCESSING(102, "Processing"),
    CHECKPOINT(103, "Checkpoint"),
    OK(200, "OK"),
    CREATED(201, "Created"),
    ACCEPTED(202, "Accepted"),
    NON_AUTHORITATIVE_INFORMATION(203, "Non-Authoritative Information"),
    NO_CONTENT(204, "No Content"),
    RESET_CONTENT(205, "Reset Content"),
    PARTIAL_CONTENT(206, "Partial Content"),
    MULTI_STATUS(207, "Multi-Status"),
    ALREADY_REPORTED(208, "Already Reported"),
    IM_USED(226, "IM Used"),
    MULTIPLE_CHOICES(300, "Multiple Choices"),
    MOVED_PERMANENTLY(301, "Moved Permanently"),
    FOUND(302, "Found"),
    MOVED_TEMPORARILY(302, "Moved Temporarily"),
    SEE_OTHER(303, "See Other"),
    NOT_MODIFIED(304, "Not Modified"),
    USE_PROXY(305, "Use Proxy"),
    TEMPORARY_REDIRECT(307, "Temporary Redirect"),
    PERMANENT_REDIRECT(308, "Permanent Redirect"),
    BAD_REQUEST(400, "Bad Request"),
    UNAUTHORIZED(401, "Unauthorized"),
    PAYMENT_REQUIRED(402, "Payment Required"),
    FORBIDDEN(403, "Forbidden"),
    NOT_FOUND(404, "Not Found"),
    METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
    NOT_ACCEPTABLE(406, "Not Acceptable"),
    PROXY_AUTHENTICATION_REQUIRED(407, "Proxy Authentication Required"),
    REQUEST_TIMEOUT(408, "Request Timeout"),
    CONFLICT(409, "Conflict"),
    GONE(410, "Gone"),
    LENGTH_REQUIRED(411, "Length Required"),
    PRECONDITION_FAILED(412, "Precondition Failed"),
    PAYLOAD_TOO_LARGE(413, "Payload Too Large"),
    REQUEST_ENTITY_TOO_LARGE(413, "Request Entity Too Large"),
    URI_TOO_LONG(414, "URI Too Long"),
    REQUEST_URI_TOO_LONG(414, "Request-URI Too Long"),
    UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
    REQUESTED_RANGE_NOT_SATISFIABLE(416, "Requested range not satisfiable"),
    EXPECTATION_FAILED(417, "Expectation Failed"),
    I_AM_A_TEAPOT(418, "I'm a teapot"),
    INSUFFICIENT_SPACE_ON_RESOURCE(419, "Insufficient Space On Resource"),
    METHOD_FAILURE(420, "Method Failure"),
    DESTINATION_LOCKED(421, "Destination Locked"),
    UNPROCESSABLE_ENTITY(422, "Unprocessable Entity"),
    LOCKED(423, "Locked"),
    FAILED_DEPENDENCY(424, "Failed Dependency"),
    UPGRADE_REQUIRED(426, "Upgrade Required"),
    PRECONDITION_REQUIRED(428, "Precondition Required"),
    TOO_MANY_REQUESTS(429, "Too Many Requests"),
    REQUEST_HEADER_FIELDS_TOO_LARGE(431, "Request Header Fields Too Large"),
    UNAVAILABLE_FOR_LEGAL_REASONS(451, "Unavailable For Legal Reasons"),
    INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
    NOT_IMPLEMENTED(501, "Not Implemented"),
    BAD_GATEWAY(502, "Bad Gateway"),
    SERVICE_UNAVAILABLE(503, "Service Unavailable"),
    GATEWAY_TIMEOUT(504, "Gateway Timeout"),
    HTTP_VERSION_NOT_SUPPORTED(505, "HTTP Version not supported"),
    VARIANT_ALSO_NEGOTIATES(506, "Variant Also Negotiates"),
    INSUFFICIENT_STORAGE(507, "Insufficient Storage"),
    LOOP_DETECTED(508, "Loop Detected"),
    BANDWIDTH_LIMIT_EXCEEDED(509, "Bandwidth Limit Exceeded"),
    NOT_EXTENDED(510, "Not Extended"),
    NETWORK_AUTHENTICATION_REQUIRED(511, "Network Authentication Required"),


    SERVER_ERROR(500, "系统升级维护中!"),
    //    SERVER_SUCCESED(200, "操作成功!"),
    PRICE_CANNOT_BE_NULL(400, "价格不能为空!"),
    USER_ID_BE_NULL(400, "用户id不能为空!"),
    USER_NOT_LOGIN(400, "当前用户未登录或登录已超时!"),
    USER_LOGIN_TIME_OUT(400, "用户登录超时，请重新登录!"),
    USER_OR_PASSWORD_IS_NULL(400, "用户名或密码不能为空!"),
    PASSWORD_ERROR(400, "用户名或密码错误!"),
    USER_IS_LOCKED(400, "用户已经被锁定!"),
    USER_IS_DELETED(400, "用户已经被删除!"),
    USER_NOT_FIND(404, "用户不存在!"),
    FILE_IS_ERROR(400, "文件格式有无，导入失败!"),
    PROJECT_ID_IS_NULL(400, "项目id不能为空!"),
    PROJECT_IS_NULL(400, "项目不存在!"),
    FILE_IS_NULL(400, "上传的文件为空!"),



    /**
     * 表示用户没有权限（令牌、用户名、密码错误）
     */
    UN_POWER(401, "用户权限不足!");

    /**
     * 结果代码编号
     */
    private Integer code;

    /**
     * 结果信息
     */
    private String msg;

}
