package com.zjty.project.state.base.result;

import com.zjty.project.state.base.response.ResponseCode;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @program: bserver
 * @description:
 * @author: LiuJie
 * @create: 2019-05-15 11:27
 **/

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ExceptionResult {
    private int status;
    private String message;
    private Long timestamp;

    public ExceptionResult(ResponseCode responseCode) {
        this.status = responseCode.getCode();
        this.message = responseCode.getMsg();
        this.timestamp = System.currentTimeMillis();
    }
}
