package com.zjty.project.state.server.controller;

import com.zjty.project.state.base.exception.MyException;
import com.zjty.project.state.base.response.ResponseCode;
import com.zjty.project.state.base.response.ServerResponse;
import com.zjty.project.state.server.pojo.user.Authority;
import com.zjty.project.state.server.service.AuthorityService;
import com.zjty.project.state.utils.ExceptionMessage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: demo
 * @description:
 * @author: LiuJie
 * @create: 2020-02-13 16:04
 **/
@Api(description = "AuthorityController权限接口")
@RestController
@RequestMapping("/authority")
public class AuthorityController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private AuthorityService roleService;
    
    @ApiOperation(value = "获取权限列表", notes = "获取权限列表：查询所有权限")
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    public ServerResponse< List<Authority> > findAll(){
        try {
            List<Authority> list= roleService.findAll();
            return ServerResponse.success(list);
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("获取权限列表失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }
}
