package com.zjty.project.state.server.controller;

import com.zjty.project.state.base.exception.MyException;
import com.zjty.project.state.base.response.ResponseCode;
import com.zjty.project.state.base.response.ServerResponse;
import com.zjty.project.state.server.pojo.Evaluate;
import com.zjty.project.state.server.service.EvaluateService;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.ExceptionMessage;
import com.zjty.project.state.utils.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @program: demo
 * @description:
 * @author: LiuJie
 * @create: 2020-02-13 16:04
 **/
@Api(description = "EvaluateController评价接口")
@RestController
@RequestMapping("/evaluate")
public class EvaluateController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private EvaluateService evaluateService;

    
    @ApiOperation(value = "评价分页查询", notes = "评价分页查询")
    @RequestMapping(value = "/search", method = RequestMethod.POST)
    public ServerResponse search(@RequestBody BaseRequest<Evaluate> baseRequest) throws Exception{
        try {
            PageResult<Evaluate> pageResult= evaluateService.search(baseRequest);
            return ServerResponse.success(pageResult);
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("评价分页查询失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }


    @ApiOperation(value = "评价审核", notes = "评价审核")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ServerResponse update(@RequestBody Evaluate evaluate) throws Exception{
        try {
            evaluate.setChecker(1);
            evaluateService.update(evaluate);
            return ServerResponse.success("评价审核成功");
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("评价审核失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }



}
