package com.zjty.project.state.server.dao;

import com.zjty.project.state.server.pojo.Produce;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;

/**
 * @program: state
 * @description:
 * @author: LiuJie
 * @create: 2020-02-26 13:46
 **/
public interface ProductDao extends JpaRepository<Produce,Integer>,JpaSpecificationExecutor {

    List<Produce> findAllByStatus(Integer status);

    @Query("select p from Produce p where p.id in :list")
    List<Produce> findProduct(@Param(value = "list") List<Integer> list);

    List<Produce> findAllByForm(Integer type);

    List<Produce> findAllByType(Integer type);
}
