package com.zjty.project.state.server.pojo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

//软件替代表
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SoftWork {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private int id;

    /**
     * 软件名称
     */
    @ApiModelProperty("软件名称")
    private String name;

    /**
     * 开始时间
     */
    @ApiModelProperty("开始时间")
    private Date startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty("结束时间")
    private Date endTime;

    /**
     * 进度
     */
    @Transient
    @ApiModelProperty("进度")
    private Integer process;

    /**
     * 是否被删除
     */
    @Transient
    private boolean deleted;

    /**
     * 描述
     */
    @ApiModelProperty("描述")
    private String des;

    /*
    绑定关系
     */

    /**
     * 技术路线id
     */
    @Transient
    @ApiModelProperty("技术路线id")
    private Integer techId;

    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Integer projectId;

    /**
     * 计划id
     */
    @Transient
    @ApiModelProperty("计划id")
    private Integer planId;

    /*
    数据存放，不生成数据库字段
     */

    /**
     * 技术路线相关数据
     */
    @Transient
    @ApiModelProperty("技术路线列表")
    private List<Tech> techs;

    /**
     * 单位与角色数据
     */
    @Transient
    @ApiModelProperty("单位与角色相关数据")
    private List<SoftUnit> units;
}
