package com.zjty.project.state.server.pojo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

//单位表
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Unit {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Integer id;
    @ApiModelProperty("单位名称")
    private String name;
//    @ApiModelProperty("单位类别1.中心方、2.建设方、3.承建方、4.产品供应商（供应软件或硬件）、5.监理方、6.测试机构、7.专家")
    @ApiModelProperty("单位类别1.AK中心2.实施系统管理员3.监理方4.集成商5.建设方6.专家7.测试机构8.开发商 ")
    private Integer type;
    @ApiModelProperty("单位地址")
    private String address;
    @ApiModelProperty("联系方式")
    private String number;
//    @ApiModelProperty("是否被删除")
//    private boolean deleted;
    @ApiModelProperty("负责人")
    private String principal;
    @ApiModelProperty("准入状态1:已准入、-1:未被准入")
    private Integer status=-1;
    @ApiModelProperty("评分")
    private double score=100.00D;

}
