package com.zjty.project.state.server.pojo.user;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.List;

//角色表
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Role {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private int id;
    @ApiModelProperty("角色名称")
    private String name;
    @ApiModelProperty("角色状态1：未删除，-1：已删除")
    private Integer status=1;
    @Transient
    @ApiModelProperty("权限ID的集合")
    private List<Integer> authorityList;
    @Transient
    @ApiModelProperty("权限的集合")
    private List<Authority> authorities;
}
