package com.zjty.project.state.server.service;

import com.zjty.project.state.server.dao.AuthorityDao;
import com.zjty.project.state.server.pojo.user.Authority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * @program: state
 * @description:
 * @author: LiuJie
 * @create: 2020-02-26 13:31
 **/
@Service
public class AuthorityService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private AuthorityDao authorityDao;


    public List<Authority> findAll() {
        return authorityDao.findAll();
    }

    public Authority findById(Integer authorityId ) {
        Optional<Authority> optional = authorityDao.findById(authorityId);
        return optional.isPresent()?optional.get():null;
    }

    public List<Authority> findAllById(List<Integer> list ) {
        return authorityDao.findAllByIdIn(list);
    }


}
