package com.zjty.project.state.server.service;

import com.github.wenhao.jpa.Specifications;
import com.zjty.project.state.server.dao.ComplainDao;
import com.zjty.project.state.server.pojo.Produce;
import com.zjty.project.state.server.pojo.Unit;
import com.zjty.project.state.server.pojo.complain.Complain;
import com.zjty.project.state.server.pojo.complain.Reply;
import com.zjty.project.state.server.pojo.project.Project;
import com.zjty.project.state.server.pojo.properties.Properties;
import com.zjty.project.state.server.pojo.user.User;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.PageResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @program: state
 * @description:
 * @author: LiuJie
 * @create: 2020-02-28 14:43
 **/
@Service
public class ComplainService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ComplainDao complainDao;
    @Autowired
    private ReplyService replyService;
    @Autowired
    private ProduceService produceService;
    @Autowired
    private UserService userService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private UnitService unitService;
    public PageResult<Complain> search(BaseRequest<Complain> baseRequest) {

        Specification<Complain> specifications = null;
        Complain complain = baseRequest.getT();
        if (complain==null){
            specifications = Specifications.<Complain>and()
                    .build();
        }else {
            specifications = Specifications.<Complain>and()
                    .like(complain.getContent()!=null && !Objects.equals(complain.getContent(), ""),"content","%"+complain.getContent()+"%")
                    .build();
        }
        Integer page = baseRequest.getPage();
        Integer pageSize = baseRequest.getPageSize();
        if (page==null || page<=0){
            page = 1;
        }
        if (pageSize==null || pageSize<=0){
            pageSize = 10;
        }
        Pageable pageable = PageRequest.of(page-1, pageSize, Sort.Direction.DESC, "stick","time");
        Long count = complainDao.count(specifications);
        List<Complain> complainList = complainDao.findAll(specifications,pageable).getContent();
        for (Complain c:complainList){
            Integer produceId = c.getProduceId();
            if (produceId!=null){
                Produce produce = produceService.findById(produceId);
                c.setProduceName(produce.getName());
            }
            Integer projectId = c.getProjectId();
            if (projectId!=null){
                Project project = projectService.findById(projectId);
                if (project!=null){
                    c.setProjectName(project.getName());
                }
            }
            Integer anonymity = c.getAnonymity();
            if (anonymity==1){
                c.setUserName("匿名");
            }else {
                User user = userService.findById(c.getUserId());
                if (user!=null){
                    c.setUserName(user.getName());
                }
            }
            Integer unitId = c.getUnitId();
            if (unitId!=null){
                Unit unit = unitService.findById(unitId);
                if (unit!=null){
                    c.setUnitName(unit.getName());
                }
            }
            Integer id = c.getId();
            if (id!=null){
                List<Reply> replyList = replyService.findByComplainId(id);
                if (replyList!=null&&replyList.size()>0){
                    c.setReplyList(replyList);
                    c.setReplyTime(replyList.get(0).getTime());
                }
            }

        }
        return new PageResult<>(page,pageSize,count,complainList);
    }


    @Transactional(rollbackFor = Exception.class)
    public void update(Complain complain) {
        Integer id = complain.getId();
        if (id!=null){
            Complain c = findById(id);
            Integer sign = complain.getSign();
            if (sign!=null&&(sign.equals(Properties.NUM_1)||sign.equals(Properties.NUM_f1))){
                c.setSign(sign);
            }
            Integer stick = complain.getStick();
            if (stick!=null&&(stick.equals(Properties.NUM_1)||stick.equals(Properties.NUM_f1))){
                c.setStick(stick);
            }
            complainDao.saveAndFlush(c);
            String replyContent = complain.getReplyContent();
            if (!StringUtils.isEmpty(replyContent)){
                Reply reply = new Reply(null,id,new Date(),replyContent);
                replyService.add(reply);
            }
        }

    }

    public Complain findById(Integer id) {
        if (id==null){
            return null;
        }
        Optional<Complain> optional = complainDao.findById(id);
        return optional.isPresent()?optional.get():null;
    }

    public void add(Complain complain) {
        complainDao.save(complain);
    }


}
