package com.zjty.project.state.server.service;

import com.github.wenhao.jpa.Specifications;
import com.zjty.project.state.server.dao.EvaluateDao;
import com.zjty.project.state.server.pojo.Evaluate;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.PageResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;

/**
 * @program: state
 * @description:
 * @author: LiuJie
 * @create: 2020-02-28 14:43
 **/
@Service
public class EvaluateService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private EvaluateDao evaluateDao;

    public PageResult<Evaluate> search(BaseRequest<Evaluate> baseRequest) {

        Specification<Evaluate> specifications = null;
        Evaluate evaluate = baseRequest.getT();
        if (evaluate==null){
            specifications = Specifications.<Evaluate>and()
                    .build();
        }else {
            specifications = Specifications.<Evaluate>and()
                    .like(evaluate.getTitle()!=null && !Objects.equals(evaluate.getTitle(), ""),"title","%"+evaluate.getTitle()+"%")
                    .eq(evaluate.getProduceId()!=null && !Objects.equals(evaluate.getProduceId(), ""),"produceId",evaluate.getProduceId())
                    .eq(evaluate.getUserId()!=null && !Objects.equals(evaluate.getUserId(), ""),"userId",evaluate.getUserId())
                    .eq(evaluate.getStatus()!=null && !Objects.equals(evaluate.getStatus(), ""),"status",evaluate.getStatus())
                    .build();
        }
        
        
//        Specification<Evaluate> specifications = Specifications.<Evaluate>and()
//                .like(evaluate.getTitle()!=null && !Objects.equals(evaluate.getTitle(), ""),"title","%"+evaluate.getTitle()+"%")
//                .eq(evaluate.getProduceId()!=null && !Objects.equals(evaluate.getProduceId(), ""),"produce_id",evaluate.getProduceId())
//                .eq(evaluate.getUserId()!=null && !Objects.equals(evaluate.getUserId(), ""),"user_id",evaluate.getUserId())
//                .eq(evaluate.getStatus()!=null && !Objects.equals(evaluate.getStatus(), ""),"status",evaluate.getStatus())
//                .build();
        Integer page = baseRequest.getPage();
        Integer pageSize = baseRequest.getPageSize();
        if (page==null || page<=0){
            page = 1;
        }
        if (pageSize==null || pageSize<=0){
            pageSize = 10;
        }
        Pageable pageable = PageRequest.of(page-1, pageSize, Sort.Direction.DESC, "id");
        Long count = evaluateDao.count(specifications);
        List<Evaluate> roleList = evaluateDao.findAll(specifications,pageable).getContent();
        return new PageResult<>(page,pageSize,count,roleList);
    }

    @Transactional(rollbackFor = Exception.class)
    public void update(Evaluate evaluate) {
        evaluateDao.saveAndFlush(evaluate);
    }
}
